/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlStateTracker;
import com.jozufozu.flywheel.backend.instancing.Engine;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.instancing.SerialTaskEngine;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.BatchingEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.backend.model.ArrayModelRenderer;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.core.model.WorldModel;
import com.jozufozu.flywheel.core.model.WorldModelBuilder;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.fabric.helper.Matrix4fHelper;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionGroup;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionInstanceManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderInfo;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1159;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class FlwContraption
extends ContraptionRenderInfo {
    private final ContraptionLighter<?> lighter;
    private final Map<class_1921, ArrayModelRenderer> renderLayers = new HashMap<class_1921, ArrayModelRenderer>();
    private final class_1159 modelViewPartial = new class_1159();
    private final ContraptionInstanceWorld instanceWorld;
    private boolean modelViewPartialReady;
    private class_238 lightBox;

    public FlwContraption(Contraption contraption, VirtualRenderWorld renderWorld) {
        super(contraption, renderWorld);
        this.lighter = contraption.makeLighter();
        this.instanceWorld = new ContraptionInstanceWorld(this);
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        this.buildLayers();
        if (ContraptionRenderDispatcher.canInstance()) {
            this.buildInstancedTiles();
            this.buildActors();
        }
        restoreState.restore();
    }

    public ContraptionLighter<?> getLighter() {
        return this.lighter;
    }

    public void renderStructureLayer(class_1921 layer, ContraptionProgram shader) {
        ArrayModelRenderer structure = this.renderLayers.get(layer);
        if (structure != null) {
            this.setup(shader);
            structure.draw();
        }
    }

    public void renderInstanceLayer(RenderLayerEvent event) {
        event.stack.method_22903();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        AbstractContraptionEntity entity = this.contraption.entity;
        double x = class_3532.method_16436((double)partialTicks, (double)entity.field_6038, (double)entity.method_23317());
        double y = class_3532.method_16436((double)partialTicks, (double)entity.field_5971, (double)entity.method_23318());
        double z = class_3532.method_16436((double)partialTicks, (double)entity.field_5989, (double)entity.method_23321());
        event.stack.method_22904(x - event.camX, y - event.camY, z - event.camZ);
        ContraptionMatrices.transform(event.stack, this.getMatrices().getModel());
        this.instanceWorld.engine.render((TaskEngine)SerialTaskEngine.INSTANCE, event);
        event.stack.method_22909();
    }

    @Override
    public void beginFrame(BeginFrameEvent event) {
        super.beginFrame(event);
        this.modelViewPartial.method_22668();
        this.modelViewPartialReady = false;
        if (!this.isVisible()) {
            return;
        }
        this.instanceWorld.tileInstanceManager.beginFrame((TaskEngine)SerialTaskEngine.INSTANCE, event.getCamera());
        class_243 cameraPos = event.getCameraPos();
        this.lightBox = this.lighter.lightVolume.toAABB().method_989(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
    }

    @Override
    public void setupMatrices(class_4587 viewProjection, double camX, double camY, double camZ) {
        super.setupMatrices(viewProjection, camX, camY, camZ);
        if (!this.modelViewPartialReady) {
            FlwContraption.setupModelViewPartial(this.modelViewPartial, this.getMatrices().getModel().method_23760().method_23761(), this.contraption.entity, camX, camY, camZ, AnimationTickHolder.getPartialTicks());
            this.modelViewPartialReady = true;
        }
    }

    void setup(ContraptionProgram shader) {
        if (!this.modelViewPartialReady || this.lightBox == null) {
            return;
        }
        shader.bind(this.modelViewPartial, this.lightBox);
        this.lighter.lightVolume.bind();
    }

    @Override
    public void invalidate() {
        for (ArrayModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        this.lighter.delete();
        this.instanceWorld.delete();
    }

    private void buildLayers() {
        for (ArrayModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        List blockLayers = class_1921.method_22720();
        Collection<class_3499.class_3501> renderedBlocks = this.contraption.getRenderedBlocks();
        for (class_1921 layer : blockLayers) {
            WorldModel layerModel = new WorldModelBuilder(layer).withRenderWorld((class_1920)this.renderWorld).withBlocks(renderedBlocks).intoMesh(layer + "_" + this.contraption.entity.method_5628());
            this.renderLayers.put(layer, new ArrayModelRenderer((Model)layerModel));
        }
    }

    private void buildInstancedTiles() {
        for (class_2586 te : this.contraption.maybeInstancedTileEntities) {
            if (!InstancedRenderRegistry.canInstance((class_2591)te.method_11017())) continue;
            class_1937 world = te.method_10997();
            te.method_31662((class_1937)this.renderWorld);
            this.instanceWorld.tileInstanceManager.add(te);
            te.method_31662(world);
        }
    }

    private void buildActors() {
        this.contraption.getActors().forEach(this.instanceWorld.tileInstanceManager::createActor);
    }

    public static void setupModelViewPartial(class_1159 matrix, class_1159 modelMatrix, AbstractContraptionEntity entity, double camX, double camY, double camZ, float pt) {
        float x = (float)(class_3532.method_16436((double)pt, (double)entity.field_6038, (double)entity.method_23317()) - camX);
        float y = (float)(class_3532.method_16436((double)pt, (double)entity.field_5971, (double)entity.method_23318()) - camY);
        float z = (float)(class_3532.method_16436((double)pt, (double)entity.field_5989, (double)entity.method_23321()) - camZ);
        Matrix4fHelper.setTranslation((class_1159)matrix, (float)x, (float)y, (float)z);
        matrix.method_22672(modelMatrix);
    }

    public void tick() {
        this.instanceWorld.tileInstanceManager.tick();
    }

    public static class ContraptionInstanceWorld {
        private final Engine engine;
        private final ContraptionInstanceManager tileInstanceManager;

        public ContraptionInstanceWorld(FlwContraption parent) {
            switch (Backend.getBackendType()) {
                case INSTANCING: {
                    InstancingEngine engine = InstancingEngine.builder(CreateContexts.CWORLD).setGroupFactory(ContraptionGroup.forContraption(parent)).setIgnoreOriginCoordinate(true).build();
                    this.tileInstanceManager = new ContraptionInstanceManager((MaterialManager)engine, parent.renderWorld, parent.contraption);
                    engine.addListener((InstancingEngine.OriginShiftListener)this.tileInstanceManager);
                    this.engine = engine;
                    break;
                }
                case BATCHING: {
                    this.engine = new BatchingEngine();
                    this.tileInstanceManager = new ContraptionInstanceManager((MaterialManager)this.engine, parent.renderWorld, parent.contraption);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown engine type");
                }
            }
        }

        public void delete() {
            this.engine.delete();
            this.tileInstanceManager.invalidate();
        }
    }
}

