/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerTileEntity;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class BlazeBurnerRenderer
extends SafeTileEntityRenderer<BlazeBurnerTileEntity> {
    public BlazeBurnerRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(BlazeBurnerTileEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = te.getHeatLevelFromBlock();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        float horizontalAngle = AngleHelper.rad(te.headAngle.getValue(partialTicks));
        class_1937 level = te.method_10997();
        int hashCode = te.hashCode();
        float animation = te.headAnimation.getValue(partialTicks) * 0.175f;
        class_2680 blockState = te.method_11010();
        boolean drawGoggles = te.goggles;
        boolean drawHat = te.hat;
        BlazeBurnerRenderer.renderShared(level, buffer, null, ms, blockState, horizontalAngle, animation, drawGoggles, drawHat, hashCode);
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer, LerpedFloat headAngle, boolean conductor) {
        class_2680 state = context.state;
        if (BlazeBurnerBlock.getHeatLevelOf(state) == BlazeBurnerBlock.HeatLevel.KINDLED) {
            state = (class_2680)state.method_11657(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.FADING));
        }
        float value = AngleHelper.rad(headAngle.getValue(AnimationTickHolder.getPartialTicks((class_1936)context.world)));
        BlazeBurnerRenderer.renderShared(context.world, buffer, matrices.getModel(), matrices.getViewProjection(), state, value, 0.0f, context.tileData.method_10545("Goggles"), conductor, context.hashCode());
    }

    private static void renderShared(class_1937 level, class_4597 buffer, @Nullable class_4587 modelTransform, class_4587 ms, class_2680 blockState, float horizontalAngle, float animation, boolean drawGoggles, boolean drawHat, int hashCode) {
        PartialModel blazeModel;
        boolean blockAbove = animation > 0.125f;
        BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.getHeatLevelOf(blockState);
        float time = AnimationTickHolder.getRenderTime((class_1936)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = class_3532.method_15374((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = class_3532.method_15374((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = class_3532.method_15374((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        class_4588 solid = buffer.getBuffer(class_1921.method_23577());
        class_4588 cutout = buffer.getBuffer(class_1921.method_23579());
        ms.method_22903();
        if (modelTransform == null && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && blockAbove) {
            SpriteShiftEntry spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().method_4577() - spriteShift.getTarget().method_4594();
            float spriteHeight = spriteShift.getTarget().method_4575() - spriteShift.getTarget().method_4593();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            BlazeBurnerRenderer.draw(CachedBufferer.partial(AllBlockPartials.BLAZE_BURNER_FLAME, blockState).shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll), horizontalAngle, modelTransform, ms, cutout);
        }
        PartialModel partialModel = blazeModel = modelTransform != null ? AllBlockPartials.BLAZE_IDLE : AllBlockPartials.BLAZE_INERT;
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            blazeModel = blockAbove ? AllBlockPartials.BLAZE_SUPER_ACTIVE : AllBlockPartials.BLAZE_SUPER;
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            blazeModel = blockAbove && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.KINDLED) ? AllBlockPartials.BLAZE_ACTIVE : AllBlockPartials.BLAZE_IDLE;
        }
        float headY = offset - animation * 0.75f;
        BlazeBurnerRenderer.draw(CachedBufferer.partial(blazeModel, blockState).translate(0.0, headY, 0.0), horizontalAngle, modelTransform, ms, solid);
        if (drawGoggles) {
            BlazeBurnerRenderer.draw(CachedBufferer.partial(blazeModel == AllBlockPartials.BLAZE_INERT ? AllBlockPartials.BLAZE_GOGGLES_SMALL : AllBlockPartials.BLAZE_GOGGLES, blockState).translate(0.0, headY + 0.5f, 0.0), horizontalAngle, modelTransform, ms, solid);
        }
        if (drawHat) {
            SuperByteBuffer partial = CachedBufferer.partial(AllBlockPartials.TRAIN_HAT, blockState).translate(0.0, headY, 0.0);
            if (blazeModel == AllBlockPartials.BLAZE_INERT) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial.translateY(0.5)).centre()).scale(0.75f)).unCentre();
            } else {
                partial.translateY(0.75);
            }
            if (modelTransform != null) {
                partial.transform(modelTransform);
            }
            partial.rotateCentered(class_2350.field_11036, horizontalAngle + (float)Math.PI).translate(0.5, 0.0, 0.5).light(0xF000F0).renderInto(ms, solid);
        }
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) || modelTransform != null) {
            PartialModel rods = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllBlockPartials.BLAZE_BURNER_SUPER_RODS : AllBlockPartials.BLAZE_BURNER_RODS;
            PartialModel rods2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllBlockPartials.BLAZE_BURNER_SUPER_RODS_2 : AllBlockPartials.BLAZE_BURNER_RODS_2;
            BlazeBurnerRenderer.draw(CachedBufferer.partial(rods, blockState).translate(0.0, offset1 + animation + 0.125f, 0.0), 0.0f, modelTransform, ms, solid);
            BlazeBurnerRenderer.draw(CachedBufferer.partial(rods2, blockState).translate(0.0, offset2 + animation - 0.1875f, 0.0), 0.0f, modelTransform, ms, solid);
        }
        ms.method_22909();
    }

    private static void draw(SuperByteBuffer blazeBuffer, float horizontalAngle, @Nullable class_4587 modelTransform, class_4587 ms, class_4588 vb) {
        if (modelTransform != null) {
            blazeBuffer.transform(modelTransform);
        }
        blazeBuffer.rotateCentered(class_2350.field_11036, horizontalAngle).light(0xF000F0).renderInto(ms, vb);
    }
}

