/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmAngleTarget;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class ArmInteractionPoint {
    protected final ArmInteractionPointType type;
    protected class_1937 level;
    protected final class_2338 pos;
    protected Mode mode = Mode.DEPOSIT;
    protected class_2680 cachedState;
    protected BlockApiCache<Storage<ItemVariant>, class_2350> cachedHandler = null;
    protected ArmAngleTarget cachedAngles;

    public ArmInteractionPoint(ArmInteractionPointType type, class_1937 level, class_2338 pos, class_2680 state) {
        this.type = type;
        this.level = level;
        this.pos = pos;
        this.cachedState = state;
    }

    public ArmInteractionPointType getType() {
        return this.type;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public void setLevel(class_1937 level) {
        this.level = level;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void cycleMode() {
        this.mode = this.mode == Mode.DEPOSIT ? Mode.TAKE : Mode.DEPOSIT;
    }

    protected class_243 getInteractionPositionVector() {
        return VecHelper.getCenterOf((class_2382)this.pos);
    }

    protected class_2350 getInteractionDirection() {
        return class_2350.field_11033;
    }

    public ArmAngleTarget getTargetAngles(class_2338 armPos, boolean ceiling) {
        if (this.cachedAngles == null) {
            this.cachedAngles = new ArmAngleTarget(armPos, this.getInteractionPositionVector(), this.getInteractionDirection(), ceiling);
        }
        return this.cachedAngles;
    }

    public void updateCachedState() {
        this.cachedState = this.level.method_8320(this.pos);
    }

    public boolean isValid() {
        this.updateCachedState();
        return this.type.canCreatePoint(this.level, this.pos, this.cachedState);
    }

    public void keepAlive() {
    }

    @Nullable
    protected Storage<ItemVariant> getHandler() {
        if (this.cachedHandler == null) {
            this.cachedHandler = TransferUtil.getItemCache((class_1937)this.level, (class_2338)this.pos);
        }
        return (Storage)this.cachedHandler.find((Object)class_2350.field_11036);
    }

    public class_1799 insert(class_1799 stack, TransactionContext ctx) {
        Storage<ItemVariant> handler = this.getHandler();
        if (handler == null) {
            return stack;
        }
        long inserted = handler.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), ctx);
        return ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)ItemHelper.truncateLong((long)stack.method_7947() - inserted));
    }

    public class_1799 extract(int amount, TransactionContext ctx) {
        Storage<ItemVariant> handler = this.getHandler();
        if (handler == null) {
            return class_1799.field_8037;
        }
        return TransferUtil.extractAnyItem(handler, (long)amount);
    }

    public class_1799 extract(TransactionContext ctx) {
        return this.extract(64, ctx);
    }

    protected void serialize(class_2487 nbt, class_2338 anchor) {
        NBTHelper.writeEnum(nbt, "Mode", this.mode);
    }

    protected void deserialize(class_2487 nbt, class_2338 anchor) {
        this.mode = NBTHelper.readEnum(nbt, "Mode", Mode.class);
    }

    public final class_2487 serialize(class_2338 anchor) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("Type", this.type.getId().toString());
        nbt.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)this.pos.method_10059((class_2382)anchor)));
        this.serialize(nbt, anchor);
        return nbt;
    }

    @Nullable
    public static ArmInteractionPoint deserialize(class_2487 nbt, class_1937 level, class_2338 anchor) {
        class_2680 state;
        class_2960 id = class_2960.method_12829((String)nbt.method_10558("Type"));
        if (id == null) {
            return null;
        }
        ArmInteractionPointType type = ArmInteractionPointType.get(id);
        if (type == null) {
            return null;
        }
        class_2338 pos = class_2512.method_10691((class_2487)nbt.method_10562("Pos")).method_10081((class_2382)anchor);
        if (!type.canCreatePoint(level, pos, state = level.method_8320(pos))) {
            return null;
        }
        ArmInteractionPoint point = type.createPoint(level, pos, state);
        if (point == null) {
            return null;
        }
        point.deserialize(nbt, anchor);
        return point;
    }

    public static void transformPos(class_2487 nbt, StructureTransform transform) {
        class_2338 pos = class_2512.method_10691((class_2487)nbt.method_10562("Pos"));
        pos = transform.applyWithoutOffset(pos);
        nbt.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)pos));
    }

    public static boolean isInteractable(class_1937 level, class_2338 pos, class_2680 state) {
        return ArmInteractionPointType.getPrimaryType(level, pos, state) != null;
    }

    @Nullable
    public static ArmInteractionPoint create(class_1937 level, class_2338 pos, class_2680 state) {
        ArmInteractionPointType type = ArmInteractionPointType.getPrimaryType(level, pos, state);
        if (type == null) {
            return null;
        }
        return type.createPoint(level, pos, state);
    }

    public static enum Mode {
        DEPOSIT("mechanical_arm.deposit_to", 14532966),
        TAKE("mechanical_arm.extract_from", 8375776);

        private final String translationKey;
        private final int color;

        private Mode(String translationKey, int color) {
            this.translationKey = translationKey;
            this.color = color;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }
    }
}

