/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.logistics.block.redstone.ContentObserverBlock;
import com.simibubi.create.content.logistics.block.redstone.FilteredDetectorFilterSlot;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.TankManipulationBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class ContentObserverTileEntity
extends SmartTileEntity {
    private static final int DEFAULT_DELAY = 6;
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    public int turnOffTicks = 0;

    public ContentObserverTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FilteredDetectorFilterSlot()).moveText(new class_243(0.0, 5.0, 0.0));
        behaviours.add(this.filtering);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = CapManipulationBehaviourBase.InterfaceProvider.towardBlockFacing();
        this.observedInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    @Override
    public void tick() {
        super.tick();
        class_2680 state = this.method_11010();
        if (this.turnOffTicks > 0) {
            --this.turnOffTicks;
            if (this.turnOffTicks == 0) {
                this.field_11863.method_39279(this.field_11867, state.method_26204(), 1);
            }
        }
        if (!this.isActive()) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)ContentObserverBlock.field_11177);
        class_2338 targetPos = this.field_11867.method_10093(facing);
        TransportedItemStackHandlerBehaviour behaviour = TileEntityBehaviour.get((class_1922)this.field_11863, targetPos, TransportedItemStackHandlerBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.handleCenteredProcessingOnAllItems(0.45f, stack -> {
                if (!this.filtering.test(stack.stack) || this.turnOffTicks == 6) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                this.activate();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
            return;
        }
        FluidTransportBehaviour fluidBehaviour = TileEntityBehaviour.get((class_1922)this.field_11863, targetPos, FluidTransportBehaviour.TYPE);
        if (fluidBehaviour != null) {
            for (class_2350 side : Iterate.directions) {
                PipeConnection.Flow flow = fluidBehaviour.getFlow(side);
                if (flow == null || !flow.inbound || !flow.complete || !this.filtering.test(flow.fluid)) continue;
                this.activate();
                return;
            }
            return;
        }
        if (!((InvManipulationBehaviour)this.observedInventory.simulate()).extract().method_7960()) {
            this.activate();
            return;
        }
        if (!((TankManipulationBehaviour)this.observedTank.simulate()).extractAny().isEmpty()) {
            this.activate();
            return;
        }
    }

    public void activate() {
        this.activate(6);
    }

    public void activate(int ticks) {
        class_2680 state = this.method_11010();
        this.turnOffTicks = ticks;
        if (((Boolean)state.method_11654((class_2769)ContentObserverBlock.POWERED)).booleanValue()) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)ContentObserverBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.field_11863.method_8452(this.field_11867, state.method_26204());
    }

    private boolean isActive() {
        return true;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("TurnOff", this.turnOffTicks);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.turnOffTicks = compound.method_10550("TurnOff");
    }
}

