/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.content.logistics.item.filter.attribute.BookAuthorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.BookCopyAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ColorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.EnchantAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.FluidContentsAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemNameAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ShulkerFillLevelAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery.AstralSorceryAmuletAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery.AstralSorceryAttunementAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery.AstralSorceryCrystalAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery.AstralSorceryPerkGemAttribute;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.apache.commons.lang3.StringUtils;

public interface ItemAttribute {
    public static final List<ItemAttribute> types = new ArrayList<ItemAttribute>();
    public static final ItemAttribute standard = ItemAttribute.register(StandardTraits.DUMMY);
    public static final ItemAttribute inTag = ItemAttribute.register(new InTag((class_6862<class_1792>)class_3489.field_15539));
    public static final ItemAttribute inItemGroup = ItemAttribute.register(new InItemGroup(class_1761.field_7932));
    public static final ItemAttribute addedBy = ItemAttribute.register(new AddedBy("dummy"));
    public static final ItemAttribute hasEnchant = ItemAttribute.register(EnchantAttribute.EMPTY);
    public static final ItemAttribute shulkerFillLevel = ItemAttribute.register(ShulkerFillLevelAttribute.EMPTY);
    public static final ItemAttribute hasColor = ItemAttribute.register(ColorAttribute.EMPTY);
    public static final ItemAttribute hasFluid = ItemAttribute.register(FluidContentsAttribute.EMPTY);
    public static final ItemAttribute hasName = ItemAttribute.register(new ItemNameAttribute("dummy"));
    public static final ItemAttribute bookAuthor = ItemAttribute.register(new BookAuthorAttribute("dummy"));
    public static final ItemAttribute bookCopy = ItemAttribute.register(new BookCopyAttribute(-1));
    public static final ItemAttribute astralAmulet = ItemAttribute.register(new AstralSorceryAmuletAttribute("dummy", -1));
    public static final ItemAttribute astralAttunement = ItemAttribute.register(new AstralSorceryAttunementAttribute("dummy"));
    public static final ItemAttribute astralCrystal = ItemAttribute.register(new AstralSorceryCrystalAttribute("dummy"));
    public static final ItemAttribute astralPerkGem = ItemAttribute.register(new AstralSorceryPerkGemAttribute("dummy"));

    public static ItemAttribute register(ItemAttribute attributeType) {
        types.add(attributeType);
        return attributeType;
    }

    public static ItemAttribute fromNBT(class_2487 nbt) {
        for (ItemAttribute itemAttribute : types) {
            if (!itemAttribute.canRead(nbt)) continue;
            return itemAttribute.readNBT(nbt.method_10562(itemAttribute.getNBTKey()));
        }
        return null;
    }

    default public boolean appliesTo(class_1799 stack, class_1937 world) {
        return this.appliesTo(stack);
    }

    public boolean appliesTo(class_1799 var1);

    default public List<ItemAttribute> listAttributesOf(class_1799 stack, class_1937 world) {
        return this.listAttributesOf(stack);
    }

    public List<ItemAttribute> listAttributesOf(class_1799 var1);

    public String getTranslationKey();

    public void writeNBT(class_2487 var1);

    public ItemAttribute readNBT(class_2487 var1);

    default public void serializeNBT(class_2487 nbt) {
        class_2487 compound = new class_2487();
        this.writeNBT(compound);
        nbt.method_10566(this.getNBTKey(), (class_2520)compound);
    }

    default public Object[] getTranslationParameters() {
        return new String[0];
    }

    default public boolean canRead(class_2487 nbt) {
        return nbt.method_10545(this.getNBTKey());
    }

    default public String getNBTKey() {
        return this.getTranslationKey();
    }

    @Environment(value=EnvType.CLIENT)
    default public class_5250 format(boolean inverted) {
        return Lang.translateDirect("item_attributes." + this.getTranslationKey() + (inverted ? ".inverted" : ""), this.getTranslationParameters());
    }

    public static enum StandardTraits implements ItemAttribute
    {
        DUMMY(s -> false),
        PLACEABLE(s -> s.method_7909() instanceof class_1747),
        CONSUMABLE(class_1799::method_19267),
        FLUID_CONTAINER(s -> ContainerItemContext.withInitial((class_1799)s).find(FluidStorage.ITEM) != null),
        ENCHANTED(class_1799::method_7942),
        MAX_ENCHANTED(StandardTraits::maxEnchanted),
        RENAMED(class_1799::method_7938),
        DAMAGED(class_1799::method_7986),
        BADLY_DAMAGED(s -> s.method_7986() && (float)(s.method_7919() / s.method_7936()) > 0.75f),
        NOT_STACKABLE(((Predicate<class_1799>)class_1799::method_7946).negate()),
        EQUIPABLE(s -> class_1309.method_32326((class_1799)s).method_5925() != class_1304.class_1305.field_6177),
        FURNACE_FUEL(class_2609::method_11195),
        WASHABLE(InWorldProcessing::isWashable),
        HAUNTABLE(InWorldProcessing::isHauntable),
        CRUSHABLE((s, w) -> StandardTraits.testRecipe(s, w, AllRecipeTypes.CRUSHING.getType()) || StandardTraits.testRecipe(s, w, AllRecipeTypes.MILLING.getType())),
        SMELTABLE((s, w) -> StandardTraits.testRecipe(s, w, (class_3956<? extends class_1860<class_1263>>)class_3956.field_17546)),
        SMOKABLE((s, w) -> StandardTraits.testRecipe(s, w, (class_3956<? extends class_1860<class_1263>>)class_3956.field_17548)),
        BLASTABLE((s, w) -> StandardTraits.testRecipe(s, w, (class_3956<? extends class_1860<class_1263>>)class_3956.field_17547));

        private static final RecipeWrapper RECIPE_WRAPPER;
        private Predicate<class_1799> test;
        private BiPredicate<class_1799, class_1937> testWithWorld;

        private StandardTraits(Predicate<class_1799> test) {
            this.test = test;
        }

        private static boolean testRecipe(class_1799 s, class_1937 w, class_3956<? extends class_1860<class_1263>> type) {
            RECIPE_WRAPPER.method_5447(0, s.method_7972());
            return w.method_8433().method_8132(type, (class_1263)RECIPE_WRAPPER, w).isPresent();
        }

        private static boolean maxEnchanted(class_1799 s) {
            return class_1890.method_8222((class_1799)s).entrySet().stream().anyMatch(e -> ((class_1887)e.getKey()).method_8183() <= (Integer)e.getValue());
        }

        private StandardTraits(BiPredicate<class_1799, class_1937> test) {
            this.testWithWorld = test;
        }

        @Override
        public boolean appliesTo(class_1799 stack, class_1937 world) {
            if (this.testWithWorld != null) {
                return this.testWithWorld.test(stack, world);
            }
            return this.appliesTo(stack);
        }

        @Override
        public boolean appliesTo(class_1799 stack) {
            return this.test.test(stack);
        }

        @Override
        public List<ItemAttribute> listAttributesOf(class_1799 stack, class_1937 world) {
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            for (StandardTraits trait : StandardTraits.values()) {
                if (!trait.appliesTo(stack, world)) continue;
                attributes.add(trait);
            }
            return attributes;
        }

        @Override
        public List<ItemAttribute> listAttributesOf(class_1799 stack) {
            return null;
        }

        @Override
        public String getTranslationKey() {
            return Lang.asId(this.name());
        }

        @Override
        public String getNBTKey() {
            return "standard_trait";
        }

        @Override
        public void writeNBT(class_2487 nbt) {
            nbt.method_10556(this.name(), true);
        }

        @Override
        public ItemAttribute readNBT(class_2487 nbt) {
            for (StandardTraits trait : StandardTraits.values()) {
                if (!nbt.method_10545(trait.name())) continue;
                return trait;
            }
            return null;
        }

        static {
            RECIPE_WRAPPER = new RecipeWrapper(new ItemStackHandler(1));
        }
    }

    public static class InTag
    implements ItemAttribute {
        public class_6862<class_1792> tag;

        public InTag(class_6862<class_1792> tag) {
            this.tag = tag;
        }

        @Override
        public boolean appliesTo(class_1799 stack) {
            return stack.method_31573(this.tag);
        }

        @Override
        public List<ItemAttribute> listAttributesOf(class_1799 stack) {
            return stack.method_40133().map(InTag::new).collect(Collectors.toList());
        }

        @Override
        public String getTranslationKey() {
            return "in_tag";
        }

        @Override
        public Object[] getTranslationParameters() {
            return new Object[]{"#" + this.tag.comp_327()};
        }

        @Override
        public void writeNBT(class_2487 nbt) {
            nbt.method_10582("space", this.tag.comp_327().method_12836());
            nbt.method_10582("path", this.tag.comp_327().method_12832());
        }

        @Override
        public ItemAttribute readNBT(class_2487 nbt) {
            return new InTag((class_6862<class_1792>)class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(nbt.method_10558("space"), nbt.method_10558("path"))));
        }
    }

    public static class InItemGroup
    implements ItemAttribute {
        private class_1761 group;

        public InItemGroup(class_1761 group) {
            this.group = group;
        }

        @Override
        public boolean appliesTo(class_1799 stack) {
            class_1792 item = stack.method_7909();
            return item.method_7859() == this.group;
        }

        @Override
        public List<ItemAttribute> listAttributesOf(class_1799 stack) {
            class_1761 group = stack.method_7909().method_7859();
            return group == null ? Collections.emptyList() : Arrays.asList(new InItemGroup(group));
        }

        @Override
        public String getTranslationKey() {
            return "in_item_group";
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public class_5250 format(boolean inverted) {
            return Lang.translateDirect("item_attributes." + this.getTranslationKey() + (inverted ? ".inverted" : ""), this.group.method_7737());
        }

        @Override
        public void writeNBT(class_2487 nbt) {
            nbt.method_10582("path", this.group.method_7751());
        }

        @Override
        public ItemAttribute readNBT(class_2487 nbt) {
            String readPath = nbt.method_10558("path");
            for (class_1761 group : class_1761.field_7921) {
                if (!group.method_7751().equals(readPath)) continue;
                return new InItemGroup(group);
            }
            return null;
        }
    }

    public static class AddedBy
    implements ItemAttribute {
        private String modId;

        public AddedBy(String modId) {
            this.modId = modId;
        }

        @Override
        public boolean appliesTo(class_1799 stack) {
            return this.modId.equals(class_2378.field_11142.method_10221((Object)stack.method_7909()).method_12836());
        }

        @Override
        public List<ItemAttribute> listAttributesOf(class_1799 stack) {
            String id = class_2378.field_11142.method_10221((Object)stack.method_7909()).method_12836();
            return id == null ? Collections.emptyList() : Arrays.asList(new AddedBy(id));
        }

        @Override
        public String getTranslationKey() {
            return "added_by";
        }

        @Override
        public Object[] getTranslationParameters() {
            String name;
            ModContainer container = FabricLoader.getInstance().getModContainer(this.modId).orElse(null);
            name = container == null ? (name = StringUtils.capitalize((String)this.modId)) : container.getMetadata().getName();
            return new Object[]{name};
        }

        @Override
        public void writeNBT(class_2487 nbt) {
            nbt.method_10582("id", this.modId);
        }

        @Override
        public ItemAttribute readNBT(class_2487 nbt) {
            return new AddedBy(nbt.method_10558("id"));
        }
    }
}

