/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;

public class TrainMigration {
    Couple<TrackNodeLocation> locations;
    double positionOnOldEdge;
    boolean curve;
    class_243 fallback;

    public TrainMigration() {
    }

    public TrainMigration(TravellingPoint point) {
        double t = point.position / point.edge.getLength();
        this.fallback = point.edge.getPosition(t);
        this.curve = point.edge.isTurn();
        this.positionOnOldEdge = point.position;
        this.locations = Couple.create(point.node1.getLocation(), point.node2.getLocation());
    }

    public GraphLocation tryMigratingTo(TrackGraph graph) {
        TrackEdge edge;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)this.locations.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)this.locations.getSecond()));
        if (node1 != null && node2 != null && (edge = graph.getConnectionsFrom(node1).get(node2)) != null) {
            GraphLocation graphLocation = new GraphLocation();
            graphLocation.graph = graph;
            graphLocation.edge = this.locations;
            graphLocation.position = this.positionOnOldEdge;
            return graphLocation;
        }
        if (this.curve) {
            return null;
        }
        class_243 prevDirection = ((TrackNodeLocation)((Object)this.locations.getSecond())).getLocation().method_1020(((TrackNodeLocation)((Object)this.locations.getFirst())).getLocation()).method_1029();
        for (TrackNodeLocation loc : graph.getNodes()) {
            class_243 nodeVec = loc.getLocation();
            if (nodeVec.method_1025(this.fallback) > 1024.0) continue;
            TrackNode newNode1 = graph.locateNode(loc);
            for (Map.Entry<TrackNode, TrackEdge> entry : graph.getConnectionsFrom(newNode1).entrySet()) {
                class_243 intersectSphere;
                TrackEdge edge2 = entry.getValue();
                if (edge2.isTurn()) continue;
                TrackNode newNode2 = entry.getKey();
                float radius = 0.015625f;
                class_243 direction = edge2.getDirection(true);
                if (!class_3532.method_20390((double)direction.method_1026(prevDirection), (double)1.0) || (intersectSphere = VecHelper.intersectSphere(nodeVec, direction, this.fallback, radius)) == null || !class_3532.method_20390((double)direction.method_1026(intersectSphere.method_1020(nodeVec).method_1029()), (double)1.0)) continue;
                double edgeLength = edge2.getLength();
                double position = intersectSphere.method_1022(nodeVec) - (double)radius;
                if (Double.isNaN(position) || position < 0.0 || position > edgeLength) continue;
                GraphLocation graphLocation = new GraphLocation();
                graphLocation.graph = graph;
                graphLocation.edge = Couple.create(loc, newNode2.getLocation());
                graphLocation.position = position;
                return graphLocation;
            }
        }
        return null;
    }

    public class_2487 write(DimensionPalette dimensions) {
        class_2487 tag = new class_2487();
        tag.method_10556("Curve", this.curve);
        tag.method_10566("Fallback", (class_2520)VecHelper.writeNBT(this.fallback));
        tag.method_10549("Position", this.positionOnOldEdge);
        tag.method_10566("Nodes", (class_2520)this.locations.serializeEach(l -> l.write(dimensions)));
        return tag;
    }

    public static TrainMigration read(class_2487 tag, DimensionPalette dimensions) {
        TrainMigration trainMigration = new TrainMigration();
        trainMigration.curve = tag.method_10577("Curve");
        trainMigration.fallback = VecHelper.readNBT(tag.method_10554("Fallback", 6));
        trainMigration.positionOnOldEdge = tag.method_10574("Position");
        trainMigration.locations = Couple.deserializeEach(tag.method_10554("Nodes", 10), c -> TrackNodeLocation.read(c, dimensions));
        return trainMigration;
    }
}

