/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.track;

import com.google.common.base.Predicates;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.particle.CubeParticleData;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.curiosities.girder.GirderBlock;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.TrackPropagator;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.content.logistics.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.logistics.trains.track.TrackRenderer;
import com.simibubi.create.content.logistics.trains.track.TrackShape;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.block.render.DestroyProgressRenderingHandler;
import com.simibubi.create.foundation.block.render.ReducedDestroyEffects;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1946;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_2423;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_638;
import net.minecraft.class_6756;
import net.minecraft.class_761;
import net.minecraft.server.MinecraftServer;

public class TrackBlock
extends class_2248
implements ITE<TrackTileEntity>,
IWrenchable,
ITrackBlock,
ISpecialBlockItemRequirement,
ProperWaterloggedBlock,
DestroyProgressRenderingHandler,
ReducedDestroyEffects {
    public static final class_2754<TrackShape> SHAPE = class_2754.method_11850((String)"shape", TrackShape.class);
    public static final class_2746 HAS_TE = class_2746.method_11825((String)"turn");

    public TrackBlock(class_4970.class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(SHAPE, (Comparable)((Object)TrackShape.ZO))).method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> p_49915_) {
        super.method_9515(p_49915_.method_11667(new class_2769[]{SHAPE, HAS_TE, WATERLOGGED}));
    }

    public class_3610 method_9545(class_2680 state) {
        return this.fluidState(state);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 stateForPlacement = this.withWater(super.method_9605(ctx), ctx);
        if (ctx.method_8036() == null) {
            return stateForPlacement;
        }
        class_243 lookAngle = ctx.method_8036().method_5720();
        if (class_3532.method_20390((double)(lookAngle = lookAngle.method_18805(1.0, 0.0, 1.0)).method_1033(), (double)0.0)) {
            lookAngle = VecHelper.rotate(new class_243(0.0, 0.0, 1.0), -ctx.method_8036().method_36454(), class_2350.class_2351.field_11052);
        }
        lookAngle = lookAngle.method_1029();
        TrackShape best = TrackShape.ZO;
        double bestValue = 3.4028234663852886E38;
        for (TrackShape shape : TrackShape.values()) {
            class_243 axis;
            double distance;
            if (shape.isJunction() || shape.isPortal() || (distance = Math.min((axis = shape.getAxes().get(0)).method_1025(lookAngle), axis.method_1029().method_1021(-1.0).method_1025(lookAngle))) > bestValue) continue;
            bestValue = distance;
            best = shape;
        }
        class_1937 level = ctx.method_8045();
        class_243 bestAxis = best.getAxes().get(0);
        if (bestAxis.method_1027() == 1.0) {
            for (boolean neg : Iterate.trueAndFalse) {
                class_2338 offset = ctx.method_8037().method_10081((class_2382)new class_2338(bestAxis.method_1021(neg ? -1.0 : 1.0)));
                if (!level.method_8320(offset).method_26206((class_1922)level, offset, class_2350.field_11036) || level.method_8320(offset.method_10084()).method_26206((class_1922)level, offset, class_2350.field_11033)) continue;
                if (best == TrackShape.XO) {
                    TrackShape trackShape = best = neg ? TrackShape.AW : TrackShape.AE;
                }
                if (best != TrackShape.ZO) continue;
                best = neg ? TrackShape.AN : TrackShape.AS;
            }
        }
        return (class_2680)stateForPlacement.method_11657(SHAPE, (Comparable)((Object)best));
    }

    public class_3619 method_9527(class_2680 pState) {
        return class_3619.field_15972;
    }

    public void method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        super.method_9576(pLevel, pPos, pState, pPlayer);
        if (pLevel.method_8608()) {
            return;
        }
        if (!pPlayer.method_7337()) {
            return;
        }
        this.withTileEntityDo((class_1922)pLevel, pPos, te -> {
            te.cancelDrops = true;
            te.removeInboundConnections();
        });
    }

    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        if (pOldState.method_26204() == this && pState.method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(true)) == pOldState.method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(true))) {
            return;
        }
        if (pLevel.field_9236) {
            return;
        }
        class_6756 blockTicks = pLevel.method_8397();
        if (!blockTicks.method_8674(pPos, (Object)this)) {
            pLevel.method_39279(pPos, (class_2248)this, 1);
        }
        this.updateGirders(pState, pLevel, pPos, (class_6756<class_2248>)blockTicks);
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        this.withTileEntityDo((class_1922)pLevel, pPos, TrackTileEntity::validateConnections);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, Random p_60465_) {
        TrackPropagator.onRailAdded((class_1936)level, pos, state);
        if (!((TrackShape)((Object)state.method_11654(SHAPE))).isPortal()) {
            this.connectToNether(level, pos, state);
        }
    }

    protected void connectToNether(class_3218 level, class_2338 pos, class_2680 state) {
        class_2350.class_2351 portalTest;
        TrackShape shape = (TrackShape)((Object)state.method_11654(SHAPE));
        Object object = shape == TrackShape.XO ? class_2350.class_2351.field_11048 : (portalTest = shape == TrackShape.ZO ? class_2350.class_2351.field_11051 : null);
        if (portalTest == null) {
            return;
        }
        boolean pop = false;
        String fail = null;
        class_2338 failPos = null;
        for (class_2350 d : Iterate.directionsInAxis(portalTest)) {
            BlockFace otherTrack;
            class_2338 otherTrackPos;
            class_2338 portalPos = pos.method_10093(d);
            class_2680 portalState = level.method_8320(portalPos);
            if (!(portalState.method_26204() instanceof class_2423)) continue;
            pop = true;
            Pair<class_3218, BlockFace> otherSide = this.getOtherSide(level, new BlockFace(pos, d));
            if (otherSide == null) {
                fail = "missing";
                continue;
            }
            class_3218 otherLevel = otherSide.getFirst();
            class_2680 existing = otherLevel.method_8320(otherTrackPos = (otherTrack = otherSide.getSecond()).getPos());
            if (!existing.method_26207().method_15800()) {
                fail = "blocked";
                failPos = otherTrackPos;
                continue;
            }
            level.method_8652(pos, (class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)((Object)TrackShape.asPortal(d)))).method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(true)), 3);
            class_2586 te = level.method_8321(pos);
            if (te instanceof TrackTileEntity) {
                TrackTileEntity tte = (TrackTileEntity)te;
                tte.bind((class_5321<class_1937>)otherLevel.method_27983(), otherTrackPos);
            }
            otherLevel.method_8652(otherTrackPos, (class_2680)((class_2680)state.method_11657(SHAPE, (Comparable)((Object)TrackShape.asPortal(otherTrack.getFace())))).method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(true)), 3);
            class_2586 otherTe = otherLevel.method_8321(otherTrackPos);
            if (otherTe instanceof TrackTileEntity) {
                TrackTileEntity tte = (TrackTileEntity)otherTe;
                tte.bind((class_5321<class_1937>)level.method_27983(), pos);
            }
            pop = false;
        }
        if (!pop) {
            return;
        }
        level.method_22352(pos, true);
        if (fail == null) {
            return;
        }
        class_1657 player = level.method_8604((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10.0, (Predicate)Predicates.alwaysTrue());
        if (player == null) {
            return;
        }
        player.method_7353((class_2561)Components.literal("<!> ").method_10852((class_2561)Lang.translateDirect("portal_track.failed", new Object[0])).method_27692(class_124.field_1065), false);
        class_5250 component = failPos != null ? Lang.translateDirect("portal_track." + fail, failPos.method_10263(), failPos.method_10264(), failPos.method_10260()) : Lang.translateDirect("portal_track." + fail, new Object[0]);
        player.method_7353((class_2561)Components.literal(" - ").method_27692(class_124.field_1080).method_10852((class_2561)component.method_27694(st -> st.method_36139(16765876))), false);
    }

    protected Pair<class_3218, BlockFace> getOtherSide(class_3218 level, BlockFace inboundTrack) {
        class_5321 resourcekey;
        class_2338 portalPos = inboundTrack.getConnectedPos();
        class_2680 portalState = level.method_8320(portalPos);
        if (!(portalState.method_26204() instanceof class_2423)) {
            return null;
        }
        MinecraftServer minecraftserver = level.method_8503();
        class_3218 otherLevel = minecraftserver.method_3847(resourcekey = level.method_27983() == class_1937.field_25180 ? class_1937.field_25179 : class_1937.field_25180);
        if (otherLevel == null || !minecraftserver.method_3839()) {
            return null;
        }
        class_1946 teleporter = otherLevel.method_14173();
        SuperGlueEntity probe = new SuperGlueEntity((class_1937)level, new class_238(portalPos));
        probe.method_36456(inboundTrack.getFace().method_10144());
        class_5454 portalinfo = probe.method_30329(otherLevel);
        if (portalinfo == null) {
            return null;
        }
        class_2338 otherPortalPos = new class_2338(portalinfo.field_25879);
        class_2680 otherPortalState = otherLevel.method_8320(otherPortalPos);
        if (!(otherPortalState.method_26204() instanceof class_2423)) {
            return null;
        }
        class_2350 targetDirection = inboundTrack.getFace();
        if (targetDirection.method_10166() == otherPortalState.method_11654((class_2769)class_2423.field_11310)) {
            targetDirection = targetDirection.method_10170();
        }
        class_2338 otherPos = otherPortalPos.method_10093(targetDirection);
        return Pair.of(otherLevel, new BlockFace(otherPos, targetDirection.method_10153()));
    }

    public class_2680 method_9559(class_2680 state, class_2350 pDirection, class_2680 pNeighborState, class_1936 level, class_2338 pCurrentPos, class_2338 pNeighborPos) {
        this.updateWater(level, state, pCurrentPos);
        TrackShape shape = (TrackShape)((Object)state.method_11654(SHAPE));
        if (!shape.isPortal()) {
            return state;
        }
        for (class_2350 d : Iterate.horizontalDirections) {
            class_2338 portalPos;
            class_2680 portalState;
            if (TrackShape.asPortal(d) != state.method_11654(SHAPE) || pDirection != d || (portalState = level.method_8320(portalPos = pCurrentPos.method_10093(d))).method_26204() instanceof class_2423) continue;
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    @Override
    public Collection<TrackNodeLocation.DiscoveredLocation> getConnected(class_1922 worldIn, class_2338 pos, class_2680 state, boolean linear, TrackNodeLocation connectedTo) {
        Collection<TrackNodeLocation.DiscoveredLocation> list;
        class_1922 world;
        if (connectedTo != null && worldIn instanceof class_3218) {
            class_3218 sl = (class_3218)worldIn;
            v0 = sl.method_8503().method_3847(connectedTo.dimension);
        } else {
            v0 = world = worldIn;
        }
        if (this.getTrackAxes(world, pos, state).size() > 1) {
            class_243 center = class_243.method_24955((class_2382)pos).method_1031(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
            TrackShape shape = (TrackShape)((Object)state.method_11654(SHAPE));
            list = new ArrayList<TrackNodeLocation.DiscoveredLocation>();
            for (class_243 axis2 : this.getTrackAxes(world, pos, state)) {
                for (boolean fromCenter : Iterate.trueAndFalse) {
                    ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> axis2.method_1021(b != false ? 0.0 : (fromCenter ? -d.doubleValue() : d)).method_1019(center), b -> shape.getNormal(), b -> {
                        class_5321 class_53212;
                        if (world instanceof class_1937) {
                            class_1937 l = (class_1937)world;
                            class_53212 = l.method_27983();
                        } else {
                            class_53212 = class_1937.field_25179;
                        }
                        return class_53212;
                    }, axis2, null);
                }
            }
        } else {
            list = ITrackBlock.super.getConnected(world, pos, state, linear, connectedTo);
        }
        if (!((Boolean)state.method_11654((class_2769)HAS_TE)).booleanValue()) {
            return list;
        }
        if (linear) {
            return list;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof TrackTileEntity)) {
            return list;
        }
        TrackTileEntity trackTE = (TrackTileEntity)blockEntity;
        Map<class_2338, BezierConnection> connections = trackTE.getConnections();
        connections.forEach((connectedPos, bc) -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> d == 1.0 ? class_243.method_24954((class_2382)((class_2382)bc.tePositions.get((boolean)b))) : bc.starts.get((boolean)b), bc.normals::get, b -> {
            class_5321 class_53212;
            if (world instanceof class_1937) {
                class_1937 l = (class_1937)world;
                class_53212 = l.method_27983();
            } else {
                class_53212 = class_1937.field_25179;
            }
            return class_53212;
        }, null, bc));
        if (trackTE.boundLocation == null || !(world instanceof class_3218)) {
            return list;
        }
        class_3218 level = (class_3218)world;
        class_5321<class_1937> otherDim = trackTE.boundLocation.getFirst();
        class_3218 otherLevel = level.method_8503().method_3847(otherDim);
        if (otherLevel == null) {
            return list;
        }
        class_2338 boundPos = trackTE.boundLocation.getSecond();
        class_2680 boundState = otherLevel.method_8320(boundPos);
        if (!AllBlocks.TRACK.has(boundState)) {
            return list;
        }
        class_243 center = class_243.method_24955((class_2382)pos).method_1031(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
        class_243 boundCenter = class_243.method_24955((class_2382)boundPos).method_1031(0.0, this.getElevationAtCenter((class_1922)otherLevel, boundPos, boundState), 0.0);
        TrackShape shape = (TrackShape)((Object)state.method_11654(SHAPE));
        TrackShape boundShape = (TrackShape)((Object)boundState.method_11654(SHAPE));
        class_243 boundAxis = this.getTrackAxes((class_1922)otherLevel, boundPos, boundState).get(0);
        this.getTrackAxes(world, pos, state).forEach(axis -> ITrackBlock.addToListIfConnected(connectedTo, list, (d, b) -> (b != false ? axis : boundAxis).method_1021(d.doubleValue()).method_1019(b != false ? center : boundCenter), b -> (b != false ? shape : boundShape).getNormal(), b -> b != false ? level.method_27983() : otherLevel.method_27983(), axis, null));
        return list;
    }

    public void method_9496(class_2680 pState, class_1937 pLevel, class_2338 pPos, Random pRand) {
        if (!((TrackShape)((Object)pState.method_11654(SHAPE))).isPortal()) {
            return;
        }
        class_243 v = class_243.method_24954((class_2382)pPos).method_1023(0.125, 0.0, 0.125);
        CubeParticleData data = new CubeParticleData(1.0f, pRand.nextFloat(), 1.0f, 0.0125f + 0.0625f * pRand.nextFloat(), 30, false);
        pLevel.method_8406((class_2394)data, v.field_1352 + (double)(pRand.nextFloat() * 1.5f), v.field_1351 + 0.25, v.field_1350 + (double)(pRand.nextFloat() * 1.5f), 0.0, 0.04, 0.0);
    }

    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        boolean removeTE = false;
        if (!(!((Boolean)pState.method_11654((class_2769)HAS_TE)).booleanValue() || pState.method_27852(pNewState.method_26204()) && ((Boolean)pNewState.method_11654((class_2769)HAS_TE)).booleanValue())) {
            class_2586 blockEntity = pLevel.method_8321(pPos);
            if (blockEntity instanceof TrackTileEntity && !pLevel.field_9236) {
                ((TrackTileEntity)blockEntity).removeInboundConnections();
            }
            removeTE = true;
        }
        if (pNewState.method_26204() != this || pState.method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(true)) != pNewState.method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(true))) {
            TrackPropagator.onRailRemoved((class_1936)pLevel, pPos, pState);
        }
        if (removeTE) {
            pLevel.method_8544(pPos);
        }
        if (!pLevel.field_9236) {
            this.updateGirders(pState, pLevel, pPos, (class_6756<class_2248>)pLevel.method_8397());
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        for (Map.Entry<class_2338, class_3341> entry : StationTileEntity.assemblyAreas.get((class_1936)world).entrySet()) {
            StationTileEntity station;
            class_2586 class_25862;
            if (!entry.getValue().method_14662((class_2382)pos) || !((class_25862 = world.method_8321(entry.getKey())) instanceof StationTileEntity) || !(station = (StationTileEntity)class_25862).trackClicked(player, hand, this, state, pos)) continue;
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void updateGirders(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_6756<class_2248> blockTicks) {
        for (class_243 vec3 : this.getTrackAxes((class_1922)pLevel, pPos, pState)) {
            if (vec3.method_1033() > 1.0 || vec3.field_1351 != 0.0) continue;
            for (int side : Iterate.positiveAndNegative) {
                GirderBlock girderBlock;
                class_2338 girderPos = pPos.method_10074().method_10080(vec3.field_1350 * (double)side, 0.0, vec3.field_1352 * (double)side);
                class_2680 girderState = pLevel.method_8320(girderPos);
                class_2248 class_22482 = girderState.method_26204();
                if (!(class_22482 instanceof GirderBlock) || blockTicks.method_8674(girderPos, (Object)(girderBlock = (GirderBlock)class_22482))) continue;
                pLevel.method_39279(girderPos, (class_2248)girderBlock, 1);
            }
        }
    }

    public boolean method_9558(class_2680 state, class_4538 reader, class_2338 pos) {
        return reader.method_8320(pos.method_10074()).method_26204() != this;
    }

    public class_265 method_9530(class_2680 state, class_1922 p_60556_, class_2338 p_60557_, class_3726 p_60558_) {
        return this.getFullShape(state);
    }

    public class_265 method_9584(class_2680 state, class_1922 pLevel, class_2338 pPos) {
        return this.getFullShape(state);
    }

    private class_265 getFullShape(class_2680 state) {
        switch ((TrackShape)((Object)state.method_11654(SHAPE))) {
            case AE: {
                return AllShapes.TRACK_ASC.get(class_2350.field_11034);
            }
            case AW: {
                return AllShapes.TRACK_ASC.get(class_2350.field_11039);
            }
            case AN: {
                return AllShapes.TRACK_ASC.get(class_2350.field_11043);
            }
            case AS: {
                return AllShapes.TRACK_ASC.get(class_2350.field_11035);
            }
            case CR_D: {
                return AllShapes.TRACK_CROSS_DIAG;
            }
            case CR_NDX: {
                return AllShapes.TRACK_CROSS_ORTHO_DIAG.get(class_2350.field_11035);
            }
            case CR_NDZ: {
                return AllShapes.TRACK_CROSS_DIAG_ORTHO.get(class_2350.field_11035);
            }
            case CR_O: {
                return AllShapes.TRACK_CROSS;
            }
            case CR_PDX: {
                return AllShapes.TRACK_CROSS_DIAG_ORTHO.get(class_2350.field_11034);
            }
            case CR_PDZ: {
                return AllShapes.TRACK_CROSS_ORTHO_DIAG.get(class_2350.field_11034);
            }
            case ND: {
                return AllShapes.TRACK_DIAG.get(class_2350.field_11035);
            }
            case PD: {
                return AllShapes.TRACK_DIAG.get(class_2350.field_11034);
            }
            case XO: {
                return AllShapes.TRACK_ORTHO.get(class_2350.field_11034);
            }
            case ZO: {
                return AllShapes.TRACK_ORTHO.get(class_2350.field_11035);
            }
            case TE: {
                return AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11034);
            }
            case TW: {
                return AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11039);
            }
            case TS: {
                return AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11035);
            }
            case TN: {
                return AllShapes.TRACK_ORTHO_LONG.get(class_2350.field_11043);
            }
        }
        return AllShapes.TRACK_FALLBACK;
    }

    public class_265 method_9549(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        switch ((TrackShape)((Object)pState.method_11654(SHAPE))) {
            case AE: 
            case AW: 
            case AN: 
            case AS: {
                return class_259.method_1073();
            }
        }
        return AllShapes.TRACK_COLLISION;
    }

    @Override
    public class_2586 method_10123(class_2338 p_153215_, class_2680 state) {
        if (!((Boolean)state.method_11654((class_2769)HAS_TE)).booleanValue()) {
            return null;
        }
        return AllTileEntities.TRACK.create(p_153215_, state);
    }

    @Override
    public Class<TrackTileEntity> getTileEntityClass() {
        return TrackTileEntity.class;
    }

    @Override
    public class_2591<? extends TrackTileEntity> getTileEntityType() {
        return (class_2591)AllTileEntities.TRACK.get();
    }

    @Override
    public class_243 getUpNormal(class_1922 world, class_2338 pos, class_2680 state) {
        return ((TrackShape)((Object)state.method_11654(SHAPE))).getNormal();
    }

    @Override
    public List<class_243> getTrackAxes(class_1922 world, class_2338 pos, class_2680 state) {
        return ((TrackShape)((Object)state.method_11654(SHAPE))).getAxes();
    }

    @Override
    public class_243 getCurveStart(class_1922 world, class_2338 pos, class_2680 state, class_243 axis) {
        boolean vertical = axis.field_1351 != 0.0;
        return VecHelper.getCenterOf((class_2382)pos).method_1031(0.0, (double)(vertical ? 0.0f : -0.5f), 0.0).method_1019(axis.method_1021(0.5));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return class_1269.field_5812;
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_2586 blockEntity;
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        if (!level.field_9236 && !player.method_7337() && ((Boolean)state.method_11654((class_2769)HAS_TE)).booleanValue() && (blockEntity = level.method_8321(context.method_8037())) instanceof TrackTileEntity) {
            TrackTileEntity trackTE = (TrackTileEntity)blockEntity;
            trackTE.cancelDrops = true;
            trackTE.connections.values().forEach(bc -> bc.addItemsToPlayer(player));
        }
        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    public class_2680 overlay(class_1922 world, class_2338 pos, class_2680 existing, class_2680 placed) {
        if (placed.method_26204() != this) {
            return existing;
        }
        TrackShape existingShape = (TrackShape)((Object)existing.method_11654(SHAPE));
        TrackShape placedShape = (TrackShape)((Object)placed.method_11654(SHAPE));
        TrackShape combinedShape = null;
        for (boolean flip : Iterate.trueAndFalse) {
            TrackShape s2;
            TrackShape s1 = flip ? existingShape : placedShape;
            TrackShape trackShape = s2 = flip ? placedShape : existingShape;
            if (s1 == TrackShape.XO && s2 == TrackShape.ZO) {
                combinedShape = TrackShape.CR_O;
            }
            if (s1 == TrackShape.PD && s2 == TrackShape.ND) {
                combinedShape = TrackShape.CR_D;
            }
            if (s1 == TrackShape.XO && s2 == TrackShape.PD) {
                combinedShape = TrackShape.CR_PDX;
            }
            if (s1 == TrackShape.ZO && s2 == TrackShape.PD) {
                combinedShape = TrackShape.CR_PDZ;
            }
            if (s1 == TrackShape.XO && s2 == TrackShape.ND) {
                combinedShape = TrackShape.CR_NDX;
            }
            if (s1 != TrackShape.ZO || s2 != TrackShape.ND) continue;
            combinedShape = TrackShape.CR_NDZ;
        }
        if (combinedShape != null) {
            existing = (class_2680)existing.method_11657(SHAPE, combinedShape);
        }
        return existing;
    }

    public class_2680 method_9598(class_2680 state, class_2470 pRotation) {
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)((TrackShape)((Object)state.method_11654(SHAPE))).rotate(pRotation)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 pMirror) {
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)((TrackShape)((Object)state.method_11654(SHAPE))).mirror(pMirror)));
    }

    @Override
    public class_2680 getBogeyAnchor(class_1922 world, class_2338 pos, class_2680 state) {
        return (class_2680)AllBlocks.SMALL_BOGEY.getDefaultState().method_11657((class_2769)class_2741.field_12529, (Comparable)(state.method_11654(SHAPE) == TrackShape.XO ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public PartialModel prepareAssemblyOverlay(class_1922 world, class_2338 pos, class_2680 state, class_2350 direction, class_4587 ms) {
        TransformStack.cast((class_4587)ms).rotateCentered(class_2350.field_11036, AngleHelper.rad(AngleHelper.horizontalAngle(direction)));
        return AllBlockPartials.TRACK_ASSEMBLING_OVERLAY;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public PartialModel prepareTrackOverlay(class_1922 world, class_2338 pos, class_2680 state, BezierTrackPointLocation bezierPoint, class_2350.class_2352 direction, class_4587 ms, TrackTargetingBehaviour.RenderedTrackOverlayType type) {
        class_2586 class_25862;
        TransformStack msr = TransformStack.cast((class_4587)ms);
        class_243 axis = null;
        class_243 diff = null;
        class_243 normal = null;
        class_243 offset = null;
        if (bezierPoint != null && (class_25862 = world.method_8321(pos)) instanceof TrackTileEntity) {
            TrackTileEntity trackTE = (TrackTileEntity)class_25862;
            BezierConnection bc = trackTE.connections.get(bezierPoint.curveTarget());
            if (bc != null) {
                double length = class_3532.method_15357((double)(bc.getLength() * 2.0));
                int seg = bezierPoint.segment() + 1;
                double t = (double)seg / length;
                double tpre = (double)(seg - 1) / length;
                double tpost = (double)(seg + 1) / length;
                offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).method_1020(bc.getPosition(tpre)).method_1029();
                msr.translate(offset.method_1020(class_243.method_24955((class_2382)pos)));
                msr.translate(0.0, -0.25, 0.0);
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = ((TrackShape)((Object)state.method_11654(SHAPE))).getAxes().get(0);
            diff = axis.method_1021((double)direction.method_10181()).method_1029();
            normal = this.getUpNormal(world, pos, state);
        }
        class_243 angles = TrackRenderer.getModelAngles(normal, diff);
        ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateYRadians(angles.field_1351)).rotateXRadians(angles.field_1352)).unCentre();
        if (axis != null) {
            msr.translate(0.0, axis.field_1351 != 0.0 ? 0.4375 : 0.0, axis.field_1351 != 0.0 ? (double)((float)direction.method_10181() * 2.5f / 16.0f) : 0.0);
        } else {
            msr.translate(0.0, 0.25, 0.0);
            if (direction == class_2350.class_2352.field_11060) {
                msr.rotateCentered(class_2350.field_11036, (float)Math.PI);
            }
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL -> AllBlockPartials.TRACK_SIGNAL_DUAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER -> AllBlockPartials.TRACK_OBSERVER_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL -> AllBlockPartials.TRACK_SIGNAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.STATION -> AllBlockPartials.TRACK_STATION_OVERLAY;
        };
    }

    @Override
    public boolean trackEquals(class_2680 state1, class_2680 state2) {
        return state1.method_26204() == this && state2.method_26204() == this && state1.method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(false)) == state2.method_11657((class_2769)HAS_TE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 te) {
        int trackAmount = 1;
        int girderAmount = 0;
        if (te instanceof TrackTileEntity) {
            TrackTileEntity track = (TrackTileEntity)te;
            for (BezierConnection bezierConnection : track.getConnections().values()) {
                if (!bezierConnection.isPrimary()) continue;
                trackAmount += bezierConnection.getTrackItemCost();
                girderAmount += bezierConnection.getGirderItemCost();
            }
        }
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        while (trackAmount > 0) {
            stacks.add(AllBlocks.TRACK.asStack(Math.min(trackAmount, 64)));
            trackAmount -= 64;
        }
        while (girderAmount > 0) {
            stacks.add(AllBlocks.METAL_GIRDER.asStack(Math.min(girderAmount, 64)));
            girderAmount -= 64;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    @Override
    public boolean renderDestroyProgress(class_638 level, class_761 renderer, int breakerId, class_2338 pos, int progress, class_2680 blockState) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof TrackTileEntity) {
            TrackTileEntity track = (TrackTileEntity)blockEntity;
            for (class_2338 trackPos : track.connections.keySet()) {
                renderer.method_8569(pos.hashCode(), trackPos, progress);
            }
        }
        return false;
    }
}

