/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.simibubi.create.foundation.gui.ModularGuiLine;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.gui.widget.TooltipArea;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.function.BiConsumer;
import net.minecraft.class_327;
import net.minecraft.class_342;

public class ModularGuiLineBuilder {
    private ModularGuiLine target;
    private class_327 font;
    private int x;
    private int y;

    public ModularGuiLineBuilder(class_327 font, ModularGuiLine target, int x, int y) {
        this.font = font;
        this.target = target;
        this.x = x;
        this.y = y;
    }

    public ModularGuiLineBuilder addScrollInput(int x, int width, BiConsumer<ScrollInput, Label> inputTransform, String dataKey) {
        ScrollInput input = new ScrollInput(x + this.x, this.y - 4, width, 18);
        this.addScrollInput(input, inputTransform, dataKey);
        return this;
    }

    public ModularGuiLineBuilder addSelectionScrollInput(int x, int width, BiConsumer<SelectionScrollInput, Label> inputTransform, String dataKey) {
        SelectionScrollInput input = new SelectionScrollInput(x + this.x, this.y - 4, width, 18);
        this.addScrollInput(input, inputTransform, dataKey);
        return this;
    }

    public ModularGuiLineBuilder customArea(int x, int width) {
        this.target.customBoxes.add(Couple.create(x, width));
        return this;
    }

    public ModularGuiLineBuilder speechBubble() {
        this.target.speechBubble = true;
        return this;
    }

    private <T extends ScrollInput> void addScrollInput(T input, BiConsumer<T, Label> inputTransform, String dataKey) {
        Label label = new Label(input.field_22760 + 5, this.y, Components.immutableEmpty());
        label.withShadow();
        inputTransform.accept(input, label);
        input.writingTo(label);
        this.target.add(Pair.of(label, "Dummy"));
        this.target.add(Pair.of(input, dataKey));
    }

    public ModularGuiLineBuilder addIntegerTextInput(int x, int width, BiConsumer<class_342, TooltipArea> inputTransform, String dataKey) {
        return this.addTextInput(x, width, inputTransform.andThen((editBox, $) -> editBox.method_1890(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        })), dataKey);
    }

    public ModularGuiLineBuilder addTextInput(int x, int width, BiConsumer<class_342, TooltipArea> inputTransform, String dataKey) {
        class_342 input = new class_342(this.font, x + this.x + 5, this.y, width - 9, 8, Components.immutableEmpty());
        input.method_1858(false);
        input.method_1868(0xFFFFFF);
        input.method_25407(false);
        input.method_25402(0.0, 0.0, 0);
        TooltipArea tooltipArea = new TooltipArea(this.x + x, this.y - 4, width, 18);
        inputTransform.accept(input, tooltipArea);
        this.target.add(Pair.of(input, dataKey));
        this.target.add(Pair.of(tooltipArea, "Dummy"));
        return this;
    }
}

