/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widget;

import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ScrollInput
extends AbstractSimiWidget {
    protected Consumer<Integer> onScroll;
    protected int state = 0;
    protected class_2561 title = Lang.translateDirect("gui.scrollInput.defaultTitle", new Object[0]);
    protected final class_2561 scrollToModify = Lang.translateDirect("gui.scrollInput.scrollToModify", new Object[0]);
    protected final class_2561 shiftScrollsFaster = Lang.translateDirect("gui.scrollInput.shiftScrollsFaster", new Object[0]);
    protected Label displayLabel;
    protected boolean inverted;
    protected Function<Integer, class_2561> formatter;
    protected int min = 0;
    protected int max = 1;
    protected int shiftStep = 5;
    Function<ScrollValueBehaviour.StepContext, Integer> step = this.standardStep();

    public ScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.formatter = i -> Components.literal(String.valueOf(i));
    }

    public Function<ScrollValueBehaviour.StepContext, Integer> standardStep() {
        return c -> c.shift ? this.shiftStep : 1;
    }

    public ScrollInput inverted() {
        this.inverted = true;
        return this;
    }

    public ScrollInput withRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollInput calling(Consumer<Integer> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public ScrollInput format(Function<Integer, class_2561> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollInput removeCallback() {
        this.onScroll = null;
        return this;
    }

    public ScrollInput titled(class_5250 title) {
        this.title = title;
        this.updateTooltip();
        return this;
    }

    public ScrollInput withStepFunction(Function<ScrollValueBehaviour.StepContext, Integer> step) {
        this.step = step;
        return this;
    }

    public ScrollInput writingTo(Label label) {
        this.displayLabel = label;
        if (label != null) {
            this.writeToLabel();
        }
        return this;
    }

    public int getState() {
        return this.state;
    }

    public ScrollInput setState(int state) {
        this.state = state;
        this.clampState();
        this.updateTooltip();
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        return this;
    }

    public ScrollInput withShiftStep(int step) {
        this.shiftStep = step;
        return this;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.inverted) {
            delta *= -1.0;
        }
        ScrollValueBehaviour.StepContext context = new ScrollValueBehaviour.StepContext();
        context.control = AllKeys.ctrlDown();
        context.shift = AllKeys.shiftDown();
        context.currentValue = this.state;
        context.forward = delta > 0.0;
        int priorState = this.state;
        boolean shifted = AllKeys.shiftDown();
        int step = (int)Math.signum(delta) * this.step.apply(context);
        this.state += step;
        if (shifted) {
            this.state -= this.state % this.shiftStep;
        }
        this.clampState();
        if (priorState != this.state) {
            this.onChanged();
        }
        return priorState != this.state;
    }

    protected void clampState() {
        if (this.state >= this.max) {
            this.state = this.max - 1;
        }
        if (this.state < this.min) {
            this.state = this.min;
        }
    }

    public void onChanged() {
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        if (this.onScroll != null) {
            this.onScroll.accept(this.state);
        }
        this.updateTooltip();
    }

    protected void writeToLabel() {
        this.displayLabel.text = this.formatter.apply(this.state);
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title == null) {
            return;
        }
        this.toolTip.add(this.title.method_27662().method_27694(s -> s.method_36139(5476833)));
        this.toolTip.add(this.scrollToModify.method_27662().method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
        this.toolTip.add(this.shiftScrollsFaster.method_27662().method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
    }
}

