/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.crank.ValveHandleBlock;
import com.simibubi.create.content.contraptions.components.crusher.CrushingWheelBlock;
import com.simibubi.create.content.contraptions.components.waterwheel.WaterWheelBlock;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencedGearshiftBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ShaftBlock;
import com.simibubi.create.content.contraptions.relays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.contraptions.relays.encased.EncasedShaftBlock;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeBlock;
import com.simibubi.create.content.contraptions.relays.gauge.StressGaugeTileEntity;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeTileEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.utility.Pointing;
import com.tterrag.registrate.util.entry.BlockEntry;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class KineticsScenes {
    public static void shaftAsRelay(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("shaft", "Relaying rotational force using Shafts");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 gaugePos = util.grid.at(0, 1, 2);
        Selection gauge = util.select.position(gaugePos);
        scene.world.showSection(gauge, class_2350.field_11036);
        scene.world.setKineticSpeed(gauge, 0.0f);
        scene.idle(5);
        scene.world.showSection(util.select.position(5, 1, 2), class_2350.field_11033);
        scene.idle(10);
        for (int i = 4; i >= 1; --i) {
            if (i == 2) {
                scene.rotateCameraY(70.0f);
            }
            scene.idle(5);
            scene.world.showSection(util.select.position(i, 1, 2), class_2350.field_11033);
        }
        scene.world.setKineticSpeed(gauge, 64.0f);
        scene.effects.indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay.showText(1000).text("Shafts will relay rotation in a straight line.").pointAt(util.vector.of(3.0, 1.5, 2.5));
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void shaftsCanBeEncased(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("shaft_casing", "Encasing Shafts");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        Selection shaft = util.select.cuboid(new class_2338(0, 1, 2), new class_2382(5, 0, 2));
        Selection andesite = util.select.position(3, 1, 2);
        Selection brass = util.select.position(1, 1, 2);
        scene.world.showSection(shaft, class_2350.field_11033);
        scene.idle(20);
        BlockEntry<EncasedShaftBlock> andesiteEncased = AllBlocks.ANDESITE_ENCASED_SHAFT;
        class_1799 andesiteCasingItem = AllBlocks.ANDESITE_CASING.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(3, 1, 2), Pointing.DOWN).rightClick().withItem(andesiteCasingItem), 60);
        scene.idle(7);
        scene.world.setBlocks(andesite, (class_2680)andesiteEncased.getDefaultState().method_11657((class_2769)EncasedShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), true);
        scene.world.setKineticSpeed(shaft, 32.0f);
        scene.idle(10);
        BlockEntry<EncasedShaftBlock> brassEncased = AllBlocks.BRASS_ENCASED_SHAFT;
        class_1799 brassCasingItem = AllBlocks.BRASS_CASING.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(1, 0, 2), Pointing.UP).rightClick().withItem(brassCasingItem), 60);
        scene.idle(7);
        scene.world.setBlocks(brass, (class_2680)brassEncased.getDefaultState().method_11657((class_2769)EncasedShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), true);
        scene.world.setKineticSpeed(shaft, 32.0f);
        scene.idle(10);
        scene.overlay.showText(100).placeNearTarget().text("Brass or Andesite Casing can be used to decorate Shafts").pointAt(util.vector.topOf(1, 1, 2));
        scene.idle(70);
    }

    public static void cogAsRelay(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("cogwheel", "Relaying rotational force using Cogwheels");
        scene.configureBasePlate(0, 0, 5);
        class_2338 gauge = util.grid.at(4, 1, 1);
        Selection gaugeSelect = util.select.position(gauge);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.world.showSection(gaugeSelect, class_2350.field_11036);
        scene.world.setKineticSpeed(gaugeSelect, 0.0f);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 1, 3, 1, 1, 5), class_2350.field_11033);
        scene.idle(10);
        for (int i = 1; i <= 4; ++i) {
            scene.idle(5);
            if (i == 2) {
                scene.world.showSection(util.select.position(0, 1, 2), class_2350.field_11033);
            }
            scene.world.showSection(util.select.position(i, 1, 2), class_2350.field_11033);
        }
        scene.world.setKineticSpeed(gaugeSelect, 64.0f);
        scene.effects.indicateSuccess(gauge);
        scene.idle(10);
        scene.overlay.showText(60).text("Cogwheels will relay rotation to other adjacent cogwheels").pointAt(util.vector.blockSurface(util.grid.at(0, 1, 2), class_2350.field_11034));
        scene.idle(60);
        scene.world.showSection(util.select.fromTo(1, 1, 1, 2, 1, 1), class_2350.field_11035);
        scene.idle(10);
        scene.effects.rotationDirectionIndicator(util.grid.at(1, 1, 1));
        scene.effects.rotationDirectionIndicator(util.grid.at(2, 1, 1));
        scene.idle(20);
        scene.overlay.showText(100).text("Neighbouring shafts connected like this will rotate in opposite directions").placeNearTarget().attachKeyFrame().pointAt(util.vector.blockSurface(util.grid.at(1, 1, 2), class_2350.field_11043));
        scene.idle(70);
    }

    public static void largeCogAsRelay(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("large_cogwheel", "Relaying rotational force using Large Cogwheels");
        scene.configureBasePlate(1, 1, 5);
        scene.world.setBlock(util.grid.at(4, 2, 3), (class_2680)AllBlocks.LARGE_COGWHEEL.getDefaultState().method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.layer(1), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(3, 2, 4), class_2350.field_11043);
        for (i = 3; i >= 1; --i) {
            scene.idle(5);
            if (i == 3) {
                scene.world.showSection(util.select.position(3, 2, 5), class_2350.field_11033);
            }
            scene.world.showSection(util.select.position(3, 2, i), class_2350.field_11033);
        }
        scene.overlay.showText(70).text("Large cogwheels can connect to each other at right angles").placeNearTarget().pointAt(util.vector.centerOf(3, 1, 4));
        scene.idle(70);
        scene.world.hideSection(util.select.fromTo(3, 2, 1, 3, 2, 5), class_2350.field_11035);
        scene.idle(15);
        scene.world.modifyBlock(util.grid.at(3, 2, 3), s -> (class_2680)s.method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.world.setKineticSpeed(util.select.fromTo(1, 2, 3, 5, 2, 3), 16.0f);
        scene.world.showSection(util.select.position(4, 2, 3), class_2350.field_11039);
        for (i = 3; i >= 1; --i) {
            scene.idle(5);
            if (i == 3) {
                scene.world.showSection(util.select.position(5, 2, 3), class_2350.field_11033);
            }
            scene.world.showSection(util.select.position(i, 2, 3), class_2350.field_11033);
        }
        scene.idle(5);
        scene.overlay.showText(90).text("It will help relaying conveyed speed to other axes of rotation").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(1, 2, 3), class_2350.field_11039));
        scene.effects.rotationSpeedIndicator(util.grid.at(3, 1, 3));
        scene.effects.rotationSpeedIndicator(util.grid.at(4, 2, 3));
        scene.idle(60);
    }

    public static void cogsSpeedUp(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("cog_speedup", "Gearshifting with Cogs");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(5, 1, 2, 4, 1, 2), class_2350.field_11033);
        scene.idle(10);
        class_2338 lowerCog = util.grid.at(3, 1, 2);
        class_2338 upperCog = util.grid.at(3, 2, 3);
        class_2680 largeCogState = (class_2680)AllBlocks.LARGE_COGWHEEL.getDefaultState().method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048);
        class_2680 smallCogState = (class_2680)AllBlocks.COGWHEEL.getDefaultState().method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048);
        scene.world.setBlock(lowerCog, largeCogState, false);
        scene.world.setBlock(upperCog, smallCogState, false);
        class_2338 upperShaftEnd = upperCog.method_10088(3);
        class_2338 lowerShaftEnd = lowerCog.method_10088(3);
        scene.world.setKineticSpeed(util.select.fromTo(upperCog, upperShaftEnd), -64.0f);
        scene.world.showSection(util.select.fromTo(lowerCog, upperCog), class_2350.field_11034);
        scene.overlay.showText(60).text("Large and Small cogs can be connected diagonally").placeNearTarget().pointAt(util.vector.blockSurface(upperCog, class_2350.field_11039));
        scene.idle(80);
        Selection gaugesSelect = util.select.fromTo(0, 1, 2, 2, 2, 3);
        scene.world.showSection(gaugesSelect, class_2350.field_11033);
        scene.overlay.showText(60).text("Shifting from large to small cogs, the conveyed speed will be doubled").colored(PonderPalette.GREEN).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(1, 2, 3), class_2350.field_11043));
        scene.idle(10);
        scene.effects.rotationSpeedIndicator(upperCog);
        scene.idle(60);
        scene.overlay.showText(30).sharedText("rpm32").colored(PonderPalette.FAST).placeNearTarget().pointAt(util.vector.blockSurface(upperShaftEnd, class_2350.field_11039));
        scene.idle(5);
        scene.overlay.showText(30).sharedText("rpm16").colored(PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector.blockSurface(lowerShaftEnd, class_2350.field_11039));
        scene.idle(45);
        scene.world.setKineticSpeed(util.select.fromTo(lowerCog, upperShaftEnd), 0.0f);
        ElementLink<WorldSectionElement> cogs = scene.world.makeSectionIndependent(util.select.fromTo(lowerCog, upperCog));
        scene.world.moveSection(cogs, util.vector.of(0.0, 1.0, 0.0), 5);
        scene.idle(5);
        scene.world.rotateSection(cogs, 180.0, 0.0, 0.0, 10);
        scene.idle(10);
        scene.world.setBlock(lowerCog, smallCogState, false);
        scene.world.setBlock(upperCog, largeCogState, false);
        scene.world.rotateSection(cogs, 180.0, 0.0, 0.0, 0);
        scene.world.moveSection(cogs, util.vector.of(0.0, -1.0, 0.0), 5);
        scene.idle(5);
        scene.world.setKineticSpeed(util.select.fromTo(lowerCog, lowerShaftEnd), 32.0f);
        scene.world.setKineticSpeed(util.select.fromTo(upperCog, upperShaftEnd), -16.0f);
        scene.overlay.showText(80).text("Shifting the opposite way, the conveyed speed will be halved").colored(PonderPalette.RED).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(1, 2, 3), class_2350.field_11043));
        scene.idle(10);
        scene.effects.rotationSpeedIndicator(upperCog);
        scene.idle(80);
        scene.overlay.showText(60).sharedText("rpm8").colored(PonderPalette.SLOW).placeNearTarget().pointAt(util.vector.blockSurface(upperShaftEnd, class_2350.field_11039));
        scene.idle(5);
        scene.overlay.showText(60).sharedText("rpm16").colored(PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector.blockSurface(lowerShaftEnd, class_2350.field_11039));
        scene.idle(40);
    }

    public static void cogwheelsCanBeEncased(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("cogwheel_casing", "Encasing Cogwheels");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        Selection large1 = util.select.position(4, 1, 3);
        Selection small1 = util.select.fromTo(3, 1, 2, 3, 2, 2);
        Selection small2 = util.select.position(2, 1, 2);
        Selection large2 = util.select.fromTo(1, 1, 3, 1, 1, 4);
        Selection shaft2 = util.select.position(2, 2, 2);
        scene.world.setKineticSpeed(shaft2, 0.0f);
        scene.idle(10);
        scene.world.showSection(large1, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(small1, class_2350.field_11033);
        scene.world.showSection(small2, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(large2, class_2350.field_11034);
        scene.idle(20);
        BlockEntry<EncasedCogwheelBlock> andesiteEncased = AllBlocks.ANDESITE_ENCASED_COGWHEEL;
        class_1799 andesiteCasingItem = AllBlocks.ANDESITE_CASING.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(3, 0, 2), Pointing.UP).rightClick().withItem(andesiteCasingItem), 100);
        scene.idle(7);
        scene.world.setBlocks(util.select.position(3, 1, 2), (class_2680)((class_2680)andesiteEncased.getDefaultState().method_11657((class_2769)EncasedCogwheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11052)).method_11657((class_2769)EncasedCogwheelBlock.TOP_SHAFT, (Comparable)Boolean.valueOf(true)), true);
        scene.world.setKineticSpeed(util.select.position(3, 1, 2), -32.0f);
        scene.idle(15);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(2, 1, 2), Pointing.DOWN).rightClick().withItem(andesiteCasingItem), 30);
        scene.idle(7);
        scene.world.setBlocks(small2, (class_2680)andesiteEncased.getDefaultState().method_11657((class_2769)EncasedCogwheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11052), true);
        scene.world.setKineticSpeed(small2, 32.0f);
        scene.idle(15);
        BlockEntry<EncasedCogwheelBlock> brassEncased = AllBlocks.BRASS_ENCASED_LARGE_COGWHEEL;
        class_1799 brassCasingItem = AllBlocks.BRASS_CASING.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(1, 0, 3), Pointing.UP).rightClick().withItem(brassCasingItem), 60);
        scene.idle(7);
        scene.world.setBlocks(util.select.position(1, 1, 3), (class_2680)brassEncased.getDefaultState().method_11657((class_2769)EncasedCogwheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11052), true);
        scene.world.setKineticSpeed(util.select.position(1, 1, 3), -16.0f);
        scene.idle(10);
        scene.overlay.showText(70).placeNearTarget().attachKeyFrame().text("Brass or Andesite Casing can be used to decorate Cogwheels").pointAt(util.vector.topOf(1, 1, 3));
        scene.idle(80);
        ElementLink<WorldSectionElement> shaftLink = scene.world.showIndependentSection(shaft2, class_2350.field_11033);
        scene.idle(15);
        scene.overlay.showText(90).placeNearTarget().colored(PonderPalette.RED).attachKeyFrame().text("Components added after encasing will not connect to the shaft outputs").pointAt(util.vector.centerOf(2, 2, 2));
        scene.idle(90);
        scene.world.moveSection(shaftLink, new class_243(0.0, 0.5, 0.0), 10);
        scene.idle(10);
        scene.addKeyframe();
        class_243 wrenchHere = util.vector.topOf(2, 1, 2).method_1031(0.25, 0.0, -0.25);
        scene.overlay.showControls(new InputWindowElement(wrenchHere, Pointing.RIGHT).rightClick().withWrench(), 25);
        scene.idle(7);
        scene.world.cycleBlockProperty(util.grid.at(2, 1, 2), (class_2769<?>)EncasedCogwheelBlock.TOP_SHAFT);
        scene.idle(15);
        scene.world.moveSection(shaftLink, new class_243(0.0, -0.5, 0.0), 10);
        scene.idle(10);
        scene.world.setKineticSpeed(shaft2, 32.0f);
        scene.effects.rotationDirectionIndicator(util.grid.at(2, 2, 2));
        scene.idle(20);
        scene.overlay.showText(90).placeNearTarget().colored(PonderPalette.GREEN).text("The Wrench can be used to toggle connections").pointAt(wrenchHere.method_1031(-0.5, 0.0, 0.5));
        scene.idle(40);
        scene.overlay.showControls(new InputWindowElement(wrenchHere, Pointing.RIGHT).rightClick().withWrench(), 25);
        scene.idle(7);
        scene.world.cycleBlockProperty(util.grid.at(2, 1, 2), (class_2769<?>)EncasedCogwheelBlock.TOP_SHAFT);
        scene.world.setKineticSpeed(shaft2, 0.0f);
    }

    public static void gearbox(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("gearbox", "Relaying rotational force using Gearboxes");
        scene.configureBasePlate(1, 1, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.world.showSection(util.select.fromTo(4, 1, 6, 3, 2, 5), class_2350.field_11036);
        scene.idle(10);
        class_2338 largeCogBack = util.grid.at(3, 2, 4);
        class_2338 largeCogLeft = util.grid.at(4, 2, 3);
        class_2338 largeCogFront = util.grid.at(3, 2, 2);
        class_2338 largeCogRight = util.grid.at(2, 2, 3);
        scene.world.showSection(util.select.position(largeCogBack), class_2350.field_11035);
        scene.idle(5);
        scene.world.showSection(util.select.position(largeCogLeft), class_2350.field_11039);
        scene.world.showSection(util.select.position(largeCogLeft.method_10078()), class_2350.field_11039);
        scene.world.showSection(util.select.position(largeCogRight), class_2350.field_11034);
        scene.world.showSection(util.select.position(largeCogRight.method_10067()), class_2350.field_11034);
        scene.idle(5);
        scene.world.showSection(util.select.position(largeCogFront), class_2350.field_11035);
        scene.world.showSection(util.select.position(largeCogFront.method_10095()), class_2350.field_11035);
        scene.idle(10);
        scene.overlay.showText(80).colored(PonderPalette.RED).pointAt(util.vector.blockSurface(largeCogRight.method_10067(), class_2350.field_11039)).placeNearTarget().text("Jumping between axes of rotation can get bulky quickly");
        scene.idle(80);
        Selection gearbox = util.select.position(3, 2, 3);
        scene.world.hideSection(util.select.fromTo(4, 2, 2, 2, 2, 4).substract(gearbox), class_2350.field_11036);
        scene.idle(20);
        class_2680 defaultState = AllBlocks.SHAFT.getDefaultState();
        class_2680 cogState = AllBlocks.COGWHEEL.getDefaultState();
        scene.world.setBlock(largeCogBack, (class_2680)defaultState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), false);
        scene.world.setBlock(largeCogFront, (class_2680)defaultState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), false);
        scene.world.setBlock(largeCogRight, (class_2680)defaultState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.world.setBlock(largeCogLeft, (class_2680)defaultState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.world.showSection(util.select.fromTo(4, 2, 2, 2, 2, 4), class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showText(80).colored(PonderPalette.GREEN).pointAt(util.vector.topOf(3, 2, 3)).placeNearTarget().attachKeyFrame().text("A gearbox is the more compact equivalent of this setup");
        scene.idle(90);
        scene.world.setBlock(largeCogFront.method_10095(), (class_2680)cogState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), true);
        scene.world.setBlock(largeCogRight.method_10067(), (class_2680)cogState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), true);
        scene.idle(10);
        scene.effects.rotationDirectionIndicator(largeCogFront.method_10095());
        scene.effects.rotationDirectionIndicator(largeCogRight.method_10067());
        scene.idle(15);
        scene.overlay.showText(60).pointAt(util.vector.of(3.0, 2.5, 3.0)).placeNearTarget().text("Shafts around corners rotate in mirrored directions");
        scene.idle(70);
        scene.world.hideSection(util.select.fromTo(1, 2, 3, 2, 2, 3), class_2350.field_11039);
        scene.world.hideSection(util.select.fromTo(4, 2, 3, 5, 2, 3), class_2350.field_11034);
        scene.world.setBlock(largeCogBack.method_10072(), (class_2680)cogState.method_11657((class_2769)CogWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), true);
        scene.idle(10);
        scene.effects.rotationDirectionIndicator(largeCogFront.method_10095());
        scene.effects.rotationDirectionIndicator(largeCogBack.method_10072());
        scene.idle(15);
        scene.overlay.showText(60).pointAt(util.vector.centerOf(3, 2, 5)).placeNearTarget().text("Straight connections will be reversed");
    }

    public static void clutch(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("clutch", "Controlling rotational force using a Clutch");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 leverPos = util.grid.at(3, 1, 0);
        scene.world.showSection(util.select.fromTo(leverPos, leverPos.method_10072()), class_2350.field_11036);
        class_2338 gaugePos = util.grid.at(0, 1, 2);
        Selection gauge = util.select.position(gaugePos);
        scene.world.showSection(gauge, class_2350.field_11036);
        scene.world.setKineticSpeed(gauge, 0.0f);
        scene.idle(5);
        scene.world.showSection(util.select.position(5, 1, 2), class_2350.field_11033);
        scene.idle(10);
        for (int i = 4; i >= 1; --i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(i, 1, 2), class_2350.field_11033);
        }
        class_2338 clutch = util.grid.at(3, 1, 2);
        scene.world.setKineticSpeed(gauge, 32.0f);
        scene.effects.indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay.showText(50).text("Clutches will relay rotation in a straight line").placeNearTarget().pointAt(util.vector.topOf(clutch));
        scene.idle(60);
        scene.world.toggleRedstonePower(util.select.fromTo(leverPos, leverPos.method_10077(2)));
        scene.effects.indicateRedstone(leverPos);
        scene.world.setKineticSpeed(util.select.fromTo(0, 1, 2, 2, 1, 2), 0.0f);
        scene.idle(10);
        scene.idle(10);
        scene.overlay.showText(50).colored(PonderPalette.RED).text("When powered by Redstone, it breaks the connection").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(clutch));
        scene.idle(70);
        scene.world.toggleRedstonePower(util.select.fromTo(leverPos, leverPos.method_10077(2)));
        scene.effects.indicateRedstone(leverPos);
        scene.world.setKineticSpeed(util.select.fromTo(0, 1, 2, 2, 1, 2), 32.0f);
        scene.effects.indicateSuccess(gaugePos);
    }

    public static void gearshift(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("gearshift", "Controlling rotational force using a Gearshift");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 leverPos = util.grid.at(3, 1, 0);
        scene.world.showSection(util.select.fromTo(leverPos, leverPos.method_10072()), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.position(5, 1, 2), class_2350.field_11033);
        scene.idle(10);
        for (int i = 4; i >= 1; --i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(i, 1, 2), class_2350.field_11033);
        }
        class_2338 gearshift = util.grid.at(3, 1, 2);
        scene.idle(10);
        scene.overlay.showText(50).placeNearTarget().text("Gearshifts will relay rotation in a straight line").pointAt(util.vector.topOf(gearshift));
        scene.idle(60);
        scene.world.toggleRedstonePower(util.select.fromTo(leverPos, leverPos.method_10077(2)));
        scene.effects.indicateRedstone(leverPos);
        scene.world.modifyKineticSpeed(util.select.fromTo(0, 1, 2, 2, 2, 2), f -> Float.valueOf(-f.floatValue()));
        scene.effects.rotationDirectionIndicator(gearshift.method_10089(2));
        scene.effects.rotationDirectionIndicator(gearshift.method_10088(2));
        scene.idle(30);
        scene.overlay.showText(50).colored(PonderPalette.RED).placeNearTarget().text("When powered by Redstone, it reverses the transmission").attachKeyFrame().pointAt(util.vector.topOf(gearshift));
        for (int i = 0; i < 3; ++i) {
            scene.idle(60);
            scene.world.toggleRedstonePower(util.select.fromTo(leverPos, leverPos.method_10077(2)));
            scene.effects.indicateRedstone(leverPos);
            scene.world.modifyKineticSpeed(util.select.fromTo(0, 1, 2, 2, 2, 2), f -> Float.valueOf(-f.floatValue()));
            scene.effects.rotationDirectionIndicator(gearshift.method_10089(2));
            scene.effects.rotationDirectionIndicator(gearshift.method_10088(2));
        }
    }

    public static void creativeMotor(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("creative_motor", "Generating Rotational Force using Creative Motors");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 motor = util.grid.at(3, 1, 2);
        for (int i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(1 + i, 1, 2), class_2350.field_11033);
        }
        scene.idle(10);
        scene.effects.rotationSpeedIndicator(motor);
        scene.overlay.showText(50).text("Creative motors are a compact and configurable source of Rotational Force").placeNearTarget().pointAt(util.vector.topOf(motor));
        scene.idle(50);
        scene.rotateCameraY(90.0f);
        scene.idle(20);
        class_243 blockSurface = util.vector.blockSurface(motor, class_2350.field_11034);
        class_238 point = new class_238(blockSurface, blockSurface);
        class_238 expanded = point.method_1009(0.0625, (double)0.2f, (double)0.2f);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.WHITE, blockSurface, point, 1);
        scene.idle(1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.WHITE, blockSurface, expanded, 60);
        scene.overlay.showControls(new InputWindowElement(blockSurface, Pointing.DOWN).scroll(), 60);
        scene.idle(20);
        scene.overlay.showText(50).text("Scrolling on the back panel changes the RPM of the motors' rotational output").attachKeyFrame().placeNearTarget().pointAt(blockSurface);
        scene.idle(10);
        scene.world.modifyKineticSpeed(util.select.fromTo(1, 1, 2, 3, 1, 2), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.idle(50);
        scene.effects.rotationSpeedIndicator(motor);
        scene.rotateCameraY(-90.0f);
    }

    public static void waterWheel(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("water_wheel", "Generating Rotational Force using Water Wheels");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(4, 1, 1, 4, 3, 3).add(util.select.fromTo(3, 1, 3, 3, 2, 3)), class_2350.field_11033);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        class_2338 gaugePos = util.grid.at(0, 2, 2);
        for (i = 0; i < 4; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.fromTo(gaugePos.method_10089(i).method_10074(), gaugePos.method_10089(i)), class_2350.field_11033);
        }
        scene.idle(10);
        for (i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(3, 3, 3 - i), class_2350.field_11033);
        }
        scene.world.setKineticSpeed(util.select.everywhere(), -12.0f);
        scene.effects.indicateSuccess(gaugePos);
        for (i = 0; i < 2; ++i) {
            scene.idle(5);
            scene.world.showSection(util.select.position(3, 2 - i, 1), class_2350.field_11033);
        }
        class_2338 wheel = util.grid.at(3, 2, 2);
        scene.effects.rotationSpeedIndicator(wheel);
        scene.overlay.showText(50).text("Water Wheels draw force from adjacent Water Currents").placeNearTarget().pointAt(util.vector.topOf(wheel));
        scene.idle(50);
        class_238 bb = new class_238(wheel).method_1009(0.125, 0.0, 0.0);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 1.2, 0.0).method_1002(0.0, 0.75, 0.0), 80);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 0.0, 1.2).method_1002(0.0, 0.0, 0.75), 80);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, -1.2, 0.0).method_1002(0.0, -0.75, 0.0), 80);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.MEDIUM, new Object(), bb.method_989(0.0, 0.0, -1.2).method_1002(0.0, 0.0, -0.75), 80);
        scene.idle(5);
        scene.overlay.showText(50).text("The more faces are powered, the faster the Water Wheel will rotate").colored(PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector.topOf(wheel));
        scene.idle(80);
        scene.rotateCameraY(-30.0f);
        scene.overlay.showText(70).text("The Wheels' blades should be oriented against the flow").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(wheel));
        scene.idle(80);
        ElementLink<WorldSectionElement> water = scene.world.makeSectionIndependent(util.select.fromTo(3, 1, 1, 3, 3, 1).add(util.select.fromTo(3, 3, 2, 3, 3, 3)));
        ElementLink<WorldSectionElement> wheelElement = scene.world.makeSectionIndependent(util.select.position(wheel));
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.world.moveSection(water, util.vector.of(0.0, 2.0, -2.0), 10);
        scene.world.moveSection(wheelElement, util.vector.of(0.0, 1.0, -1.0), 10);
        scene.idle(10);
        scene.world.rotateSection(wheelElement, 0.0, 180.0, 0.0, 5);
        scene.idle(10);
        scene.world.modifyBlock(wheel, s -> (class_2680)s.method_11657((class_2769)WaterWheelBlock.FACING, (Comparable)class_2350.field_11039), false);
        scene.world.rotateSection(wheelElement, 0.0, -180.0, 0.0, 0);
        scene.idle(1);
        scene.world.moveSection(water, util.vector.of(0.0, -2.0, 2.0), 10);
        scene.world.moveSection(wheelElement, util.vector.of(0.0, -1.0, 1.0), 10);
        scene.idle(10);
        scene.world.setKineticSpeed(util.select.everywhere(), -8.0f);
        scene.overlay.showText(70).colored(PonderPalette.RED).text("Facing the opposite way, they will not be as effective").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(wheel));
        scene.idle(80);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.world.moveSection(water, util.vector.of(0.0, 2.0, -2.0), 10);
        scene.world.moveSection(wheelElement, util.vector.of(0.0, 1.0, -1.0), 10);
        scene.idle(10);
        scene.rotateCameraY(30.0f);
        scene.world.rotateSection(wheelElement, 0.0, 180.0, 0.0, 5);
        scene.idle(10);
        scene.world.modifyBlock(wheel, s -> (class_2680)s.method_11657((class_2769)WaterWheelBlock.FACING, (Comparable)class_2350.field_11034), false);
        scene.world.rotateSection(wheelElement, 0.0, -180.0, 0.0, 0);
        scene.idle(1);
        scene.world.moveSection(water, util.vector.of(0.0, -2.0, 2.0), 10);
        scene.world.moveSection(wheelElement, util.vector.of(0.0, -1.0, 1.0), 10);
        scene.idle(10);
        scene.world.setKineticSpeed(util.select.everywhere(), -12.0f);
        scene.effects.indicateSuccess(gaugePos);
    }

    public static void handCrank(SceneBuilder scene, SceneBuildingUtil util) {
        KineticsScenes.manualSource(scene, util, true);
    }

    public static void valveHandle(SceneBuilder scene, SceneBuildingUtil util) {
        KineticsScenes.manualSource(scene, util, false);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.idle(20);
        class_243 centerOf = util.vector.centerOf(2, 2, 2);
        scene.overlay.showControls(new InputWindowElement(centerOf, Pointing.DOWN).rightClick().withItem(new class_1799((class_1935)class_1802.field_8345)), 40);
        scene.idle(7);
        scene.world.modifyBlock(util.grid.at(2, 2, 2), s -> (class_2680)AllBlocks.DYED_VALVE_HANDLES.get(class_1767.field_7966).getDefaultState().method_11657((class_2769)ValveHandleBlock.FACING, (Comparable)class_2350.field_11036), true);
        scene.idle(10);
        scene.overlay.showText(70).text("Valve handles can be dyed for aesthetic purposes").placeNearTarget().pointAt(centerOf);
    }

    private static void manualSource(SceneBuilder scene, SceneBuildingUtil util, boolean handCrank) {
        String name = handCrank ? "Hand Cranks" : "Valve Handles";
        scene.title(handCrank ? "hand_crank" : "valve_handle", "Generating Rotational Force using " + name);
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 gaugePos = util.grid.at(1, 3, 3);
        class_2338 handlePos = util.grid.at(2, 2, 2);
        Selection handleSelect = util.select.position(handlePos);
        scene.world.showSection(util.select.layersFrom(1).substract(handleSelect), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(handleSelect, class_2350.field_11033);
        scene.idle(20);
        class_243 centerOf = util.vector.centerOf(handlePos);
        scene.overlay.showText(70).text(name + " can be used by players to apply rotational force manually").placeNearTarget().pointAt(centerOf);
        scene.idle(80);
        scene.overlay.showControls(new InputWindowElement(centerOf, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        scene.world.setKineticSpeed(util.select.everywhere(), handCrank ? 32.0f : 16.0f);
        scene.world.modifyKineticSpeed(util.select.column(1, 3), f -> Float.valueOf(f.floatValue() * -2.0f));
        scene.effects.rotationDirectionIndicator(handlePos);
        scene.effects.indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay.showText(50).text("Hold Right-Click to rotate it Counter-Clockwise").attachKeyFrame().placeNearTarget().pointAt(centerOf);
        scene.idle(70);
        scene.overlay.showText(50).colored(handCrank ? PonderPalette.MEDIUM : PonderPalette.SLOW).text("Its conveyed speed is " + (handCrank ? "relatively high" : "slow and precise")).placeNearTarget().pointAt(centerOf);
        scene.idle(70);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(centerOf, Pointing.DOWN).rightClick().whileSneaking(), 40);
        scene.idle(7);
        scene.world.setKineticSpeed(util.select.everywhere(), handCrank ? -32.0f : -16.0f);
        scene.world.modifyKineticSpeed(util.select.column(1, 3), f -> Float.valueOf(f.floatValue() * -2.0f));
        scene.effects.rotationDirectionIndicator(handlePos);
        scene.effects.indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay.showText(90).text("Sneak and Hold Right-Click to rotate it Clockwise").attachKeyFrame().placeNearTarget().pointAt(centerOf);
        scene.idle(90);
    }

    public static void sequencedGearshift(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("sequenced_gearshift", "Controlling Rotational Speed using Sequenced Gearshifts");
        scene.configureBasePlate(1, 0, 5);
        scene.showBasePlate();
        Selection redstone = util.select.fromTo(3, 1, 0, 3, 1, 1);
        scene.world.showSection(util.select.position(6, 0, 3).add(redstone), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(6, 1, 2, 4, 1, 2), class_2350.field_11033);
        class_2338 gearshiftPos = util.grid.at(3, 1, 2);
        Selection gearshiftSelection = util.select.position(gearshiftPos);
        class_2338 bearingPos = util.grid.at(1, 1, 2);
        class_2338 buttonPos = util.grid.at(3, 1, 0);
        Selection outputKinetics = util.select.fromTo(3, 1, 2, 1, 1, 2);
        scene.world.setKineticSpeed(gearshiftSelection, 0.0f);
        scene.idle(10);
        scene.world.showSection(gearshiftSelection, class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(2, 1, 2, 1, 1, 2), class_2350.field_11034);
        scene.idle(10);
        class_243 top = util.vector.topOf(gearshiftPos);
        scene.overlay.showText(60).text("Seq. Gearshifts relay rotation by following a timed list of instructions").attachKeyFrame().pointAt(top).placeNearTarget();
        scene.idle(80);
        scene.overlay.showControls(new InputWindowElement(top, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        scene.overlay.showSelectionWithText(gearshiftSelection, 50).colored(PonderPalette.BLUE).text("Right-click it to open the Configuration UI").pointAt(top).placeNearTarget();
        scene.idle(60);
        ElementLink<WorldSectionElement> contraption = scene.world.showIndependentSection(util.select.fromTo(0, 3, 2, 0, 0, 2), class_2350.field_11034);
        scene.world.configureCenterOfRotation(contraption, util.vector.centerOf(bearingPos));
        scene.idle(20);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(buttonPos);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, 16.0f);
        scene.world.rotateBearing(bearingPos, 90.0f, 40);
        scene.world.rotateSection(contraption, 90.0, 0.0, 0.0, 40);
        scene.effects.rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.idle(20);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(20);
        scene.overlay.showText(80).text("Upon receiving a Redstone Signal, it will start running its configured sequence").attachKeyFrame().pointAt(top);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, -32.0f);
        scene.world.rotateBearing(bearingPos, -180.0f, 40);
        scene.world.rotateSection(contraption, -180.0, 0.0, 0.0, 40);
        scene.effects.rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.idle(40);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, 0.0f);
        scene.idle(20);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, 16.0f);
        scene.world.rotateBearing(bearingPos, 90.0f, 40);
        scene.world.rotateSection(contraption, 90.0, 0.0, 0.0, 40);
        scene.effects.rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.idle(40);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, 0.0f);
        scene.idle(20);
        scene.overlay.showText(70).text("Once finished, it waits for the next Redstone Signal and starts over").pointAt(util.vector.topOf(util.grid.at(3, 0, 1)));
        scene.idle(80);
        scene.idle(20);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(buttonPos);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, 16.0f);
        scene.world.rotateBearing(bearingPos, 90.0f, 40);
        scene.world.rotateSection(contraption, 90.0, 0.0, 0.0, 40);
        scene.effects.rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.idle(20);
        scene.overlay.showText(60).text("A redstone comparator can be used to read the current progress").attachKeyFrame().pointAt(util.vector.topOf(util.grid.at(3, 0, 1)));
        scene.world.hideSection(redstone, class_2350.field_11043);
        scene.idle(15);
        class_2338 wire = util.grid.at(5, 1, 0);
        Selection nixie = util.select.position(4, 1, 0);
        ElementLink<WorldSectionElement> comparator = scene.world.showIndependentSection(util.select.fromTo(5, 1, 1, 4, 1, 0), class_2350.field_11035);
        scene.world.moveSection(comparator, util.vector.of(-2.0, 0.0, 0.0), 0);
        scene.world.toggleRedstonePower(util.select.position(5, 1, 1));
        scene.world.cycleBlockProperty(wire, (class_2769<?>)class_2457.field_11432);
        scene.world.modifyTileNBT(nixie, NixieTubeTileEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 1));
        scene.idle(5);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, -32.0f);
        scene.world.rotateBearing(bearingPos, -180.0f, 40);
        scene.world.rotateSection(contraption, -180.0, 0.0, 0.0, 40);
        scene.effects.rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.world.cycleBlockProperty(wire, (class_2769<?>)class_2457.field_11432);
        scene.world.modifyTileNBT(nixie, NixieTubeTileEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 2));
        scene.idle(40);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, 0.0f);
        scene.world.cycleBlockProperty(wire, (class_2769<?>)class_2457.field_11432);
        scene.world.modifyTileNBT(nixie, NixieTubeTileEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 3));
        scene.idle(20);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.setKineticSpeed(outputKinetics, 16.0f);
        scene.world.rotateBearing(bearingPos, 90.0f, 40);
        scene.world.rotateSection(contraption, 90.0, 0.0, 0.0, 40);
        scene.effects.rotationDirectionIndicator(gearshiftPos.method_10067());
        scene.world.cycleBlockProperty(wire, (class_2769<?>)class_2457.field_11432);
        scene.world.modifyTileNBT(nixie, NixieTubeTileEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 4));
        scene.idle(40);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.cycleBlockProperty(gearshiftPos, (class_2769<?>)SequencedGearshiftBlock.STATE);
        scene.world.modifyBlock(wire, s -> (class_2680)s.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(0)), false);
        scene.world.toggleRedstonePower(util.select.position(5, 1, 1));
        scene.world.modifyTileNBT(nixie, NixieTubeTileEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 0));
        scene.world.setKineticSpeed(outputKinetics, 0.0f);
    }

    public static void speedController(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("rotation_speed_controller", "Using the Rotational Speed Controller");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 cogPos = util.grid.at(1, 2, 1);
        Selection gaugeSelect = util.select.position(1, 2, 3);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 0.5f);
        scene.world.setKineticSpeed(gaugeSelect, 0.0f);
        scene.world.showSection(util.select.fromTo(5, 1, 1, 2, 1, 1), class_2350.field_11033);
        scene.world.showSection(util.select.fromTo(1, 1, 3, 1, 2, 3), class_2350.field_11033);
        scene.idle(10);
        ElementLink<WorldSectionElement> rsc = scene.world.showIndependentSection(util.select.position(0, 1, 1), class_2350.field_11033);
        scene.world.moveSection(rsc, util.vector.of(1.0, 0.0, 0.0), 0);
        ElementLink<WorldSectionElement> rsc2 = scene.world.showIndependentSection(util.select.position(1, 1, 1), class_2350.field_11033);
        scene.world.moveSection(rsc2, util.vector.of(0.0, -100.0, 0.0), 0);
        scene.idle(10);
        scene.world.showSection(util.select.position(1, 2, 1), class_2350.field_11033);
        scene.idle(15);
        scene.effects.indicateSuccess(cogPos);
        scene.world.moveSection(rsc2, util.vector.of(0.0, 100.0, 0.0), 0);
        scene.world.moveSection(rsc, util.vector.of(0.0, -100.0, 0.0), 0);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 2, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world.setKineticSpeed(gaugeSelect, 8.0f);
        scene.effects.indicateSuccess(util.grid.at(1, 2, 3));
        scene.overlay.showText(90).placeNearTarget().attachKeyFrame().pointAt(util.vector.blockSurface(cogPos, class_2350.field_11043)).text("Rot. Speed Controllers relay rotation from their axis to a Large Cogwheel above them");
        scene.idle(100);
        class_243 inputVec = util.vector.of(1.5, 1.75, 1.0);
        scene.overlay.showFilterSlotInput(inputVec, 60);
        scene.overlay.showText(70).placeNearTarget().attachKeyFrame().pointAt(inputVec).text("Using the scroll input on its side, the conveyed speed can be configured");
        scene.idle(80);
        InputWindowElement input = new InputWindowElement(inputVec, Pointing.UP).scroll();
        scene.overlay.showControls(input, 40);
        scene.idle(15);
        scene.world.multiplyKineticSpeed(util.select.fromTo(1, 2, 1, 1, 2, 3), 4.0f);
        scene.effects.rotationSpeedIndicator(cogPos);
        scene.idle(55);
        scene.markAsFinished();
        scene.overlay.showControls(input, 30);
        scene.idle(15);
        scene.world.multiplyKineticSpeed(util.select.fromTo(1, 2, 1, 1, 2, 3), 4.0f);
        scene.effects.rotationSpeedIndicator(cogPos);
        scene.idle(55);
        scene.overlay.showControls(input, 30);
        scene.idle(15);
        scene.world.multiplyKineticSpeed(util.select.fromTo(1, 2, 1, 1, 2, 3), -0.05f);
        scene.effects.rotationSpeedIndicator(cogPos);
        scene.idle(35);
    }

    public static void speedometer(SceneBuilder scene, SceneBuildingUtil util) {
        KineticsScenes.gauge(scene, util, true);
    }

    public static void stressometer(SceneBuilder scene, SceneBuildingUtil util) {
        KineticsScenes.gauge(scene, util, false);
    }

    private static void gauge(SceneBuilder scene, SceneBuildingUtil util, boolean speed) {
        String component = speed ? "Speedometer" : "Stressometer";
        String title = "Monitoring Kinetic information using the " + component;
        scene.title(speed ? "speedometer" : "stressometer", title);
        scene.configureBasePlate(1, 0, 5);
        class_2338 gaugePos = util.grid.at(2, 1, 3);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        for (int x = 6; x >= 0; --x) {
            scene.idle(2);
            scene.world.showSection(util.select.position(x, 1, 3), class_2350.field_11033);
        }
        scene.idle(10);
        scene.world.setBlock(gaugePos, (class_2680)(speed ? AllBlocks.SPEEDOMETER : AllBlocks.STRESSOMETER).getDefaultState().method_11657((class_2769)GaugeBlock.FACING, (Comparable)class_2350.field_11036), true);
        scene.world.setKineticSpeed(util.select.position(gaugePos), 32.0f);
        scene.idle(10);
        scene.overlay.showText(80).text("The " + component + " displays the current " + (speed ? "Speed" : "Stress Capacity") + " of the attached " + (speed ? "components" : "kinetic network")).attachKeyFrame().pointAt(util.vector.topOf(gaugePos)).placeNearTarget();
        scene.idle(90);
        if (speed) {
            scene.world.multiplyKineticSpeed(util.select.everywhere(), 4.0f);
            scene.effects.rotationSpeedIndicator(util.grid.at(6, 1, 3));
            scene.idle(5);
            scene.effects.indicateSuccess(gaugePos);
        } else {
            class_2680 state = (class_2680)AllBlocks.CRUSHING_WHEEL.getDefaultState().method_11657((class_2769)CrushingWheelBlock.AXIS, (Comparable)class_2350.class_2351.field_11048);
            scene.world.setBlock(util.grid.at(5, 1, 3), state, true);
            scene.world.setKineticSpeed(util.select.position(5, 1, 3), 32.0f);
            scene.world.modifyTileNBT(util.select.position(gaugePos), StressGaugeTileEntity.class, nbt -> nbt.method_10548("Value", 0.5f));
            scene.effects.indicateRedstone(gaugePos);
            scene.idle(20);
            scene.world.setBlock(util.grid.at(4, 1, 3), state, true);
            scene.world.setKineticSpeed(util.select.position(4, 1, 3), 32.0f);
            scene.world.modifyTileNBT(util.select.position(gaugePos), StressGaugeTileEntity.class, nbt -> nbt.method_10548("Value", 0.9f));
            scene.effects.indicateRedstone(gaugePos);
            scene.idle(10);
        }
        scene.idle(30);
        class_243 blockSurface = util.vector.blockSurface(gaugePos, class_2350.field_11043);
        scene.overlay.showControls(new InputWindowElement(blockSurface, Pointing.RIGHT).withItem(AllItems.GOGGLES.asStack()), 40);
        scene.idle(7);
        scene.overlay.showText(80).text("When wearing Engineers' Goggles, the player can get more detailed information from the Gauge").attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(blockSurface).placeNearTarget();
        scene.idle(100);
        Selection comparator = util.select.fromTo(2, 1, 1, 2, 1, 2);
        scene.world.showSection(comparator, class_2350.field_11035);
        scene.idle(10);
        scene.world.toggleRedstonePower(comparator);
        scene.effects.indicateRedstone(util.grid.at(2, 1, 2));
        scene.idle(20);
        scene.overlay.showText(120).text("Comparators can emit analog Restone Signals relative to the " + component + "'s measurements").attachKeyFrame().colored(PonderPalette.RED).pointAt(util.vector.centerOf(2, 1, 2).method_1031(0.0, -0.35, 0.0)).placeNearTarget();
        scene.idle(130);
        scene.markAsFinished();
    }

    public static void creativeMotorMojang(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("creative_motor_mojang", "Mojang's Enigma");
        scene.configureBasePlate(0, 0, 15);
        scene.scaleSceneView(0.55f);
        scene.showBasePlate();
        scene.idle(15);
        scene.world.showSection(util.select.fromTo(12, 1, 7, 12, 1, 2), class_2350.field_11039);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(5, 1, 2, 7, 2, 1), class_2350.field_11034);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(7, 1, 3, 7, 1, 8), class_2350.field_11043);
        scene.idle(3);
        scene.world.showSection(util.select.position(7, 2, 8), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.position(4, 1, 4), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.position(4, 1, 6), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.position(3, 1, 10), class_2350.field_11035);
        scene.idle(3);
        scene.world.showSection(util.select.position(1, 1, 11), class_2350.field_11034);
        scene.idle(3);
        scene.world.showSection(util.select.position(11, 1, 3), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(11, 2, 3, 11, 2, 7), class_2350.field_11043);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(8, 1, 2, 10, 1, 2), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.position(11, 1, 2), class_2350.field_11035);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(6, 1, 8, 5, 1, 8), class_2350.field_11034);
        scene.rotateCameraY(-90.0f);
        scene.idle(3);
        scene.world.showSection(util.select.position(12, 1, 10), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.position(11, 1, 12), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(8, 1, 8, 11, 1, 8), class_2350.field_11039);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(5, 2, 8, 5, 3, 8), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(8, 1, 5, 8, 2, 7), class_2350.field_11039);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(7, 3, 9, 8, 3, 8), class_2350.field_11036);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(6, 3, 7, 9, 3, 7).add(util.select.fromTo(6, 3, 8, 6, 3, 10)).add(util.select.fromTo(7, 3, 10, 9, 3, 10)).add(util.select.fromTo(9, 3, 7, 9, 3, 9)), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(10, 4, 7, 6, 4, 10), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.fromTo(8, 1, 13, 8, 2, 11), class_2350.field_11043);
        scene.idle(3);
        scene.idle(20);
    }
}

