/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerTileEntity;
import com.simibubi.create.content.logistics.block.diodes.BrassDiodeBlock;
import com.simibubi.create.content.logistics.block.diodes.PoweredLatchBlock;
import com.simibubi.create.content.logistics.block.diodes.PulseExtenderTileEntity;
import com.simibubi.create.content.logistics.block.diodes.PulseRepeaterTileEntity;
import com.simibubi.create.content.logistics.block.diodes.ToggleLatchBlock;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverTileEntity;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeBlock;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeTileEntity;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkBlock;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkTileEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.ParrotElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_5250;

public class RedstoneScenes {
    public static void sticker(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("sticker", "Attaching blocks using the Sticker");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Selection redstone = util.select.fromTo(0, 2, 2, 2, 2, 2);
        class_2338 stickerPos = util.grid.at(2, 2, 2);
        Selection stickerSelect = util.select.position(stickerPos);
        class_2338 buttonPos = util.grid.at(0, 2, 2);
        class_2338 bearingPos = util.grid.at(2, 1, 2);
        scene.world.showSection(util.select.fromTo(2, 1, 2, 0, 2, 2).substract(stickerSelect), class_2350.field_11033);
        scene.idle(10);
        ElementLink<WorldSectionElement> sticker = scene.world.showIndependentSection(stickerSelect, class_2350.field_11033);
        scene.idle(10);
        ElementLink<WorldSectionElement> plank = scene.world.showIndependentSection(util.select.position(2, 2, 1), class_2350.field_11035);
        scene.world.configureCenterOfRotation(sticker, util.vector.centerOf(stickerPos));
        scene.world.configureCenterOfRotation(plank, util.vector.centerOf(stickerPos));
        scene.overlay.showText(60).text("Stickers are ideal for Redstone-controlled block attachment").attachKeyFrame().pointAt(util.vector.blockSurface(stickerPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        scene.world.toggleRedstonePower(redstone);
        scene.world.modifyBlock(stickerPos, s -> (class_2680)s.method_11657((class_2769)StickerBlock.EXTENDED, (Comparable)Boolean.valueOf(true)), false);
        scene.effects.indicateRedstone(buttonPos);
        scene.world.modifyTileNBT(stickerSelect, StickerTileEntity.class, nbt -> {});
        scene.idle(20);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(20);
        scene.overlay.showText(60).text("Upon receiving a signal, it will toggle its state").pointAt(util.vector.blockSurface(stickerPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        scene.world.rotateBearing(bearingPos, 540.0f, 80);
        scene.world.rotateSection(sticker, 0.0, 540.0, 0.0, 80);
        scene.world.rotateSection(plank, 0.0, 540.0, 0.0, 80);
        scene.overlay.showText(70).text("If it is now moved in a contraption, the block will move with it").pointAt(util.vector.topOf(stickerPos)).placeNearTarget();
        scene.idle(90);
        scene.addKeyframe();
        scene.world.toggleRedstonePower(redstone);
        scene.world.modifyBlock(stickerPos, s -> (class_2680)s.method_11657((class_2769)StickerBlock.EXTENDED, (Comparable)Boolean.valueOf(false)), false);
        scene.effects.indicateRedstone(buttonPos);
        scene.world.modifyTileNBT(stickerSelect, StickerTileEntity.class, nbt -> {});
        scene.idle(20);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(20);
        scene.overlay.showText(60).text("Toggled once again, the block is no longer attached").pointAt(util.vector.blockSurface(stickerPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        scene.world.rotateBearing(bearingPos, 540.0f, 80);
        scene.world.rotateSection(sticker, 0.0, 540.0, 0.0, 80);
    }

    public static void contact(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("redstone_contact", "Redstone Contacts");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Selection contactAndRedstone = util.select.fromTo(1, 1, 0, 1, 1, 2);
        Selection topContact = util.select.position(1, 2, 2);
        scene.world.toggleRedstonePower(contactAndRedstone);
        scene.world.toggleRedstonePower(topContact);
        scene.world.showSection(contactAndRedstone, class_2350.field_11033);
        class_2338 bearingPos = util.grid.at(3, 1, 2);
        scene.idle(25);
        ElementLink<WorldSectionElement> contact = scene.world.showIndependentSection(topContact, class_2350.field_11033);
        scene.idle(10);
        scene.world.toggleRedstonePower(topContact);
        scene.world.toggleRedstonePower(contactAndRedstone);
        scene.effects.indicateRedstone(util.grid.at(1, 1, 2));
        scene.idle(10);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.of(1.0, 2.0, 2.5)).text("Redstone Contacts facing each other will emit a redstone signal");
        scene.idle(70);
        scene.world.showSection(util.select.position(bearingPos), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSectionAndMerge(util.select.fromTo(2, 2, 2, 4, 2, 2), class_2350.field_11033, contact);
        scene.idle(10);
        scene.effects.superGlue(util.grid.at(1, 2, 2), class_2350.field_11034, true);
        scene.world.configureCenterOfRotation(contact, util.vector.centerOf(bearingPos));
        int speed = 2;
        scene.idle(10);
        scene.world.rotateBearing(bearingPos, 10.0f, speed);
        scene.world.rotateSection(contact, 0.0, 10.0, 0.0, speed);
        scene.idle(speed);
        scene.world.toggleRedstonePower(topContact);
        scene.world.toggleRedstonePower(contactAndRedstone);
        scene.effects.indicateRedstone(util.grid.at(1, 1, 2));
        scene.world.rotateBearing(bearingPos, 340.0f, 34 * speed);
        scene.world.rotateSection(contact, 0.0, 340.0, 0.0, 34 * speed);
        scene.addKeyframe();
        scene.idle(34 * speed);
        scene.overlay.showText(100).placeNearTarget().pointAt(util.vector.of(1.0, 1.5, 2.5)).text("This still applies when one of them is part of a moving Contraption");
        for (int i = 0; i < 5; ++i) {
            scene.world.toggleRedstonePower(topContact);
            scene.world.toggleRedstonePower(contactAndRedstone);
            scene.effects.indicateRedstone(util.grid.at(1, 1, 2));
            scene.world.rotateBearing(bearingPos, 20.0f, 2 * speed);
            scene.world.rotateSection(contact, 0.0, 20.0, 0.0, 2 * speed);
            scene.idle(2 * speed);
            scene.world.toggleRedstonePower(topContact);
            scene.world.toggleRedstonePower(contactAndRedstone);
            scene.world.rotateBearing(bearingPos, 340.0f, 34 * speed);
            scene.world.rotateSection(contact, 0.0, 340.0, 0.0, 34 * speed);
            scene.idle(34 * speed);
            if (i != 0) continue;
            scene.markAsFinished();
        }
        scene.world.toggleRedstonePower(topContact);
        scene.world.toggleRedstonePower(contactAndRedstone);
        scene.world.rotateBearing(bearingPos, 10.0f, speed);
        scene.world.rotateSection(contact, 0.0, 10.0, 0.0, speed);
    }

    public static void pulseExtender(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("pulse_extender", "Controlling signals using Pulse Extenders");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 circuitPos = util.grid.at(2, 1, 2);
        class_2338 leverPos = util.grid.at(4, 1, 2);
        scene.world.modifyTileNBT(util.select.position(circuitPos), PulseExtenderTileEntity.class, nbt -> nbt.method_10569("ScrollValue", 30));
        scene.world.showSection(util.select.layersFrom(1).substract(util.select.position(circuitPos)), class_2350.field_11036);
        scene.idle(10);
        scene.world.showSection(util.select.position(circuitPos), class_2350.field_11033);
        scene.idle(20);
        class_243 circuitTop = util.vector.blockSurface(circuitPos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        scene.overlay.showText(70).text("Pulse Extenders can lengthen a signal passing through").attachKeyFrame().placeNearTarget().pointAt(circuitTop);
        scene.idle(60);
        scene.effects.indicateRedstone(leverPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(2);
        scene.world.toggleRedstonePower(util.select.fromTo(1, 1, 2, 0, 1, 2));
        scene.idle(15);
        scene.overlay.showText(60).text("They activate after a short delay...").placeNearTarget().pointAt(util.vector.topOf(util.grid.at(0, 1, 2)));
        scene.idle(50);
        scene.effects.indicateRedstone(leverPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(30);
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world.toggleRedstonePower(util.select.position(1, 1, 2));
        scene.idle(1);
        scene.world.toggleRedstonePower(util.select.position(0, 1, 2));
        scene.idle(15);
        scene.overlay.showText(40).text("...and cool down for the configured duration").placeNearTarget().pointAt(util.vector.topOf(util.grid.at(0, 1, 2)));
        scene.idle(50);
        scene.overlay.showRepeaterScrollInput(circuitPos, 60);
        scene.overlay.showControls(new InputWindowElement(circuitTop, Pointing.DOWN).scroll(), 60);
        scene.idle(10);
        scene.overlay.showText(60).text("Using the mouse wheel, the discharge time can be configured").attachKeyFrame().placeNearTarget().pointAt(circuitTop);
        scene.world.modifyTileNBT(util.select.position(circuitPos), PulseExtenderTileEntity.class, nbt -> nbt.method_10569("ScrollValue", 120));
        scene.idle(70);
        scene.effects.indicateRedstone(leverPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(2);
        scene.world.toggleRedstonePower(util.select.fromTo(1, 1, 2, 0, 1, 2));
        scene.idle(20);
        scene.effects.indicateRedstone(leverPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(15);
        scene.overlay.showText(50).text("The configured duration can range up to 30 minutes").placeNearTarget().pointAt(circuitTop);
        scene.idle(70);
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world.toggleRedstonePower(util.select.position(1, 1, 2));
        scene.idle(1);
        scene.world.toggleRedstonePower(util.select.position(0, 1, 2));
        scene.idle(15);
    }

    public static void pulseRepeater(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("pulse_repeater", "Controlling signals using Pulse Repeaters");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 circuitPos = util.grid.at(2, 1, 2);
        class_2338 leverPos = util.grid.at(4, 1, 2);
        scene.world.modifyTileNBT(util.select.position(circuitPos), PulseRepeaterTileEntity.class, nbt -> nbt.method_10569("ScrollValue", 30));
        scene.world.showSection(util.select.layersFrom(1).substract(util.select.position(circuitPos)), class_2350.field_11036);
        scene.idle(10);
        scene.world.showSection(util.select.position(circuitPos), class_2350.field_11033);
        scene.idle(20);
        class_243 circuitTop = util.vector.blockSurface(circuitPos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        scene.effects.indicateRedstone(leverPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(30);
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world.toggleRedstonePower(util.select.fromTo(1, 1, 2, 0, 1, 2));
        scene.idle(2);
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world.toggleRedstonePower(util.select.position(1, 1, 2));
        scene.idle(1);
        scene.world.toggleRedstonePower(util.select.position(0, 1, 2));
        scene.idle(15);
        scene.overlay.showText(60).text("Pulse Repeaters emit a short pulse at a delay").attachKeyFrame().placeNearTarget().pointAt(circuitTop);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(70);
        scene.overlay.showRepeaterScrollInput(circuitPos, 60);
        scene.overlay.showControls(new InputWindowElement(circuitTop, Pointing.DOWN).scroll(), 60);
        scene.idle(10);
        scene.overlay.showText(60).text("Using the mouse wheel, the charge time can be configured").attachKeyFrame().placeNearTarget().pointAt(circuitTop);
        scene.world.modifyTileNBT(util.select.position(circuitPos), PulseRepeaterTileEntity.class, nbt -> nbt.method_10569("ScrollValue", 120));
        scene.idle(70);
        scene.effects.indicateRedstone(leverPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 2, 1, 2));
        scene.idle(60);
        scene.overlay.showText(50).text("Configured delays can range up to 30 minutes").placeNearTarget().pointAt(circuitTop);
        scene.idle(60);
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world.toggleRedstonePower(util.select.fromTo(1, 1, 2, 0, 1, 2));
        scene.idle(2);
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)BrassDiodeBlock.POWERING);
        scene.world.toggleRedstonePower(util.select.position(1, 1, 2));
        scene.idle(1);
        scene.world.toggleRedstonePower(util.select.position(0, 1, 2));
    }

    public static void poweredLatch(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("powered_latch", "Controlling signals using the Powered Latch");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 circuitPos = util.grid.at(2, 1, 2);
        class_2338 buttonPos = util.grid.at(4, 1, 2);
        class_243 circuitTop = util.vector.blockSurface(circuitPos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        scene.world.showSection(util.select.layersFrom(1).substract(util.select.position(circuitPos)), class_2350.field_11036);
        scene.idle(10);
        scene.world.showSection(util.select.position(circuitPos), class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showText(40).attachKeyFrame().text("Powered Latches are redstone controllable Levers").placeNearTarget().pointAt(circuitTop);
        scene.idle(50);
        scene.effects.indicateRedstone(buttonPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 0, 1, 2));
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)PoweredLatchBlock.POWERING);
        scene.idle(30);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 3, 1, 2));
        class_238 bb = new class_238(circuitPos).method_1009((double)-0.48f, (double)-0.45f, (double)-0.05f).method_989(0.575, -0.45, 0.0);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, bb, bb, 40);
        scene.overlay.showText(40).colored(PonderPalette.GREEN).text("Signals at the back switch it on").placeNearTarget().pointAt(bb.method_1005());
        scene.idle(60);
        scene.effects.indicateRedstone(util.grid.at(2, 1, 0));
        scene.world.toggleRedstonePower(util.select.fromTo(2, 1, 0, 2, 1, 1));
        scene.world.toggleRedstonePower(util.select.fromTo(2, 1, 2, 0, 1, 2));
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)PoweredLatchBlock.POWERING);
        scene.idle(30);
        scene.world.toggleRedstonePower(util.select.fromTo(2, 1, 0, 2, 1, 1));
        bb = new class_238(circuitPos).method_1009((double)-0.05f, (double)-0.45f, (double)-0.48f).method_989(0.0, -0.45, 0.575);
        class_238 bb2 = new class_238(circuitPos).method_1009((double)-0.05f, (double)-0.45f, (double)-0.48f).method_989(0.0, -0.45, -0.575);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, bb, bb, 40);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, bb2, bb2, 40);
        scene.overlay.showText(40).colored(PonderPalette.RED).text("Signals from the side switch it back off").placeNearTarget().pointAt(bb2.method_1005());
        scene.idle(50);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(circuitTop, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        scene.world.toggleRedstonePower(util.select.fromTo(2, 1, 2, 0, 1, 2));
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)PoweredLatchBlock.POWERING);
        scene.idle(10);
        scene.overlay.showText(50).text("Powered latches can also be toggled manually").placeNearTarget().pointAt(circuitTop);
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(circuitTop, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        scene.world.toggleRedstonePower(util.select.fromTo(2, 1, 2, 0, 1, 2));
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)PoweredLatchBlock.POWERING);
        scene.idle(10);
    }

    public static void poweredToggleLatch(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("powered_toggle_latch", "Controlling signals using the Powered Toggle Latch");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 circuitPos = util.grid.at(2, 1, 2);
        class_2338 buttonPos = util.grid.at(4, 1, 2);
        class_243 circuitTop = util.vector.blockSurface(circuitPos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        scene.world.showSection(util.select.layersFrom(1).substract(util.select.position(circuitPos)), class_2350.field_11036);
        scene.idle(10);
        scene.world.showSection(util.select.position(circuitPos), class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showText(40).attachKeyFrame().text("Powered Toggle Latches are redstone controllable Levers").placeNearTarget().pointAt(circuitTop);
        scene.idle(50);
        scene.effects.indicateRedstone(buttonPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 0, 1, 2));
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)ToggleLatchBlock.POWERING);
        scene.idle(30);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 3, 1, 2));
        class_238 bb = new class_238(circuitPos).method_1009((double)-0.48f, (double)-0.45f, (double)-0.05f).method_989(0.575, -0.45, 0.0);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, bb, bb, 40);
        scene.overlay.showText(40).colored(PonderPalette.GREEN).text("Signals at the back will toggle its state").placeNearTarget().pointAt(bb.method_1005());
        scene.idle(60);
        scene.effects.indicateRedstone(buttonPos);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 0, 1, 2));
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)ToggleLatchBlock.POWERING);
        scene.idle(30);
        scene.world.toggleRedstonePower(util.select.fromTo(4, 1, 2, 3, 1, 2));
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, bb, bb, 40);
        scene.overlay.showText(30).colored(PonderPalette.RED).text("...on and back off").placeNearTarget().pointAt(bb.method_1005());
        scene.idle(50);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(circuitTop, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        scene.world.toggleRedstonePower(util.select.fromTo(2, 1, 2, 0, 1, 2));
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)ToggleLatchBlock.POWERING);
        scene.idle(10);
        scene.overlay.showText(50).text("Powered toggle latches can also be toggled manually").placeNearTarget().pointAt(circuitTop);
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(circuitTop, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        scene.world.toggleRedstonePower(util.select.fromTo(2, 1, 2, 0, 1, 2));
        scene.world.cycleBlockProperty(circuitPos, (class_2769<?>)ToggleLatchBlock.POWERING);
        scene.idle(10);
    }

    public static void analogLever(SceneBuilder scene, SceneBuildingUtil util) {
        int state;
        int i;
        scene.title("analog_lever", "Controlling signals using the Analog Lever");
        scene.configureBasePlate(0, 0, 5);
        class_2338[] wireLocations = new class_2338[]{util.grid.at(2, 1, 1), util.grid.at(2, 1, 0), util.grid.at(1, 1, 0), util.grid.at(0, 1, 0), util.grid.at(0, 1, 1), util.grid.at(0, 1, 2), util.grid.at(0, 1, 3), util.grid.at(0, 1, 4), util.grid.at(1, 1, 4), util.grid.at(2, 1, 4), util.grid.at(3, 1, 4), util.grid.at(4, 1, 4), util.grid.at(4, 1, 3), util.grid.at(4, 1, 2), util.grid.at(4, 1, 1)};
        Selection leverSelection = util.select.fromTo(2, 1, 2, 2, 2, 2);
        Selection lamp = util.select.position(4, 1, 0);
        class_2338 leverPos = util.grid.at(2, 2, 2);
        class_243 leverVec = util.vector.centerOf(leverPos).method_1031(0.0, -0.25, 0.0);
        scene.world.showSection(util.select.layersFrom(0).substract(lamp).substract(leverSelection), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(lamp, class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(leverSelection, class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showText(60).text("Analog Levers make for a compact and precise source of redstone power").placeNearTarget().attachKeyFrame().pointAt(leverVec);
        scene.idle(70);
        class_2758 power = class_2457.field_11432;
        scene.overlay.showControls(new InputWindowElement(leverVec, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        for (i = 0; i < 7; ++i) {
            scene.idle(2);
            state = i + 1;
            scene.world.modifyTileNBT(leverSelection, AnalogLeverTileEntity.class, nbt -> nbt.method_10569("State", state));
            scene.world.modifyBlock(wireLocations[i], s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(7 - state)), false);
            scene.effects.indicateRedstone(wireLocations[i]);
        }
        scene.idle(20);
        scene.overlay.showText(60).attachKeyFrame().text("Right-click to increase its analog power output").placeNearTarget().pointAt(leverVec);
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(leverVec, Pointing.DOWN).rightClick().whileSneaking(), 40);
        scene.idle(7);
        for (i = 7; i > 0; --i) {
            scene.idle(2);
            state = i - 1;
            if (i > 3) {
                scene.world.modifyTileNBT(leverSelection, AnalogLeverTileEntity.class, nbt -> nbt.method_10569("State", state));
                scene.effects.indicateRedstone(wireLocations[i]);
            }
            scene.world.modifyBlock(wireLocations[i], s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(state > 2 ? 0 : 3 - state)), false);
        }
        scene.world.modifyBlock(wireLocations[0], s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(3)), false);
        scene.idle(20);
        scene.overlay.showText(60).attachKeyFrame().text("Right-click while Sneaking to decrease the power output again").placeNearTarget().pointAt(leverVec);
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(leverVec, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        for (i = 0; i < 15; ++i) {
            scene.idle(2);
            state = i + 1;
            if (i >= 4) {
                scene.world.modifyTileNBT(leverSelection, AnalogLeverTileEntity.class, nbt -> nbt.method_10569("State", state));
                scene.effects.indicateRedstone(wireLocations[i]);
            }
            scene.world.modifyBlock(wireLocations[i], s -> (class_2680)s.method_11657((class_2769)power, (Comparable)Integer.valueOf(15 - state)), false);
        }
        scene.world.toggleRedstonePower(lamp);
        scene.effects.indicateRedstone(leverPos);
        scene.effects.indicateRedstone(util.grid.at(4, 1, 1));
        scene.idle(20);
    }

    public static void nixieTube(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("nixie_tube", "Using Nixie Tubes");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0).add(util.select.fromTo(2, 1, 1, 2, 1, 2)), class_2350.field_11036);
        scene.idle(10);
        scene.world.showSection(util.select.position(2, 1, 3), class_2350.field_11033);
        scene.idle(20);
        Selection tubes = util.select.fromTo(3, 1, 3, 1, 1, 3);
        scene.effects.indicateRedstone(util.grid.at(2, 1, 1));
        scene.world.modifyTileNBT(util.select.position(2, 1, 1), AnalogLeverTileEntity.class, nbt -> nbt.method_10569("State", 11));
        scene.world.modifyBlock(util.grid.at(2, 1, 2), s -> (class_2680)s.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(11)), false);
        scene.world.modifyTileNBT(tubes, NixieTubeTileEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 11));
        scene.idle(20);
        class_243 centerTube = util.vector.centerOf(2, 1, 3);
        scene.overlay.showText(60).attachKeyFrame().text("When powered by Redstone, Nixie Tubes will display the redstone signals' strength").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(2, 1, 3), class_2350.field_11039));
        scene.idle(70);
        scene.world.hideSection(util.select.position(2, 1, 3), class_2350.field_11036);
        scene.idle(5);
        scene.world.hideSection(util.select.fromTo(2, 1, 1, 2, 1, 2), class_2350.field_11043);
        scene.idle(10);
        scene.world.modifyTileNBT(tubes, NixieTubeTileEntity.class, nbt -> nbt.method_10569("RedstoneStrength", 0));
        scene.world.showSection(tubes, class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(centerTube.method_1031(1.0, 0.35, 0.0), Pointing.DOWN).rightClick().withItem(new class_1799((class_1935)class_1802.field_8448)), 40);
        scene.idle(7);
        class_5250 component = Components.literal("CREATE");
        for (int i = 0; i < 3; ++i) {
            int index = i;
            scene.world.modifyTileNBT(util.select.position(3 - i, 1, 3), NixieTubeTileEntity.class, arg_0 -> RedstoneScenes.lambda$nixieTube$19((class_2561)component, index, arg_0));
        }
        scene.idle(10);
        scene.world.showSection(util.select.position(4, 1, 3), class_2350.field_11033);
        scene.idle(10);
        scene.special.createBirb(util.vector.topOf(util.grid.at(0, 0, 3)), ParrotElement.DancePose::new);
        scene.idle(20);
        scene.overlay.showText(80).attachKeyFrame().placeNearTarget().text("Using name tags edited with an anvil, custom text can be displayed").pointAt(util.vector.topOf(util.grid.at(3, 1, 3)).method_1031(-0.75, (double)-0.05f, 0.0));
        scene.idle(90);
        InputWindowElement input = new InputWindowElement(util.vector.blockSurface(util.grid.at(3, 1, 3), class_2350.field_11036), Pointing.DOWN).withItem(new class_1799((class_1935)class_1802.field_8345));
        scene.overlay.showControls(input, 30);
        scene.idle(7);
        scene.world.setBlocks(util.select.fromTo(1, 1, 3, 3, 1, 3), (class_2680)AllBlocks.NIXIE_TUBES.get(class_1767.field_7966).getDefaultState().method_11657((class_2769)NixieTubeBlock.field_11177, (Comparable)class_2350.field_11039), false);
        scene.idle(10);
        scene.overlay.showText(80).colored(PonderPalette.BLUE).text("Right-Click with Dye to change their display colour").attachKeyFrame().pointAt(util.vector.topOf(util.grid.at(3, 1, 3)).method_1031(-0.75, (double)-0.05f, 0.0)).placeNearTarget();
        scene.idle(60);
    }

    public static void redstoneLink(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("redstone_link", "Using Redstone Links");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0).add(util.select.fromTo(3, 1, 1, 2, 1, 1)), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(4, 1, 3, 0, 2, 3), class_2350.field_11033);
        scene.idle(10);
        Selection redstone = util.select.fromTo(3, 1, 1, 1, 1, 1);
        class_2338 leverPos = util.grid.at(3, 1, 1);
        class_2338 link1Pos = util.grid.at(1, 1, 1);
        class_2338 link2Pos = util.grid.at(1, 2, 2);
        class_2338 link3Pos = util.grid.at(3, 2, 2);
        Selection link1Select = util.select.position(link1Pos);
        Selection link2Select = util.select.position(link2Pos);
        Selection link3Select = util.select.position(link3Pos);
        class_243 link1Vec = util.vector.blockSurface(link1Pos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0);
        class_243 link2Vec = util.vector.blockSurface(link2Pos, class_2350.field_11035).method_1031(0.0, 0.0, -0.1875);
        class_243 link3Vec = util.vector.blockSurface(link3Pos, class_2350.field_11035).method_1031(0.0, 0.0, -0.1875);
        scene.world.showSection(link1Select, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(link2Select, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(link3Select, class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(50).attachKeyFrame().text("Redstone Links can transmit redstone signals wirelessly").placeNearTarget().pointAt(link1Vec);
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(link2Vec, Pointing.UP).rightClick().whileSneaking(), 40);
        scene.idle(7);
        scene.world.modifyBlock(link2Pos, s -> (class_2680)s.method_28493((class_2769)RedstoneLinkBlock.RECEIVER), true);
        scene.idle(10);
        scene.overlay.showText(50).text("Right-click while Sneaking to toggle receive mode").placeNearTarget().pointAt(link2Vec);
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(link3Vec, Pointing.UP).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.modifyBlock(link3Pos, s -> (class_2680)s.method_28493((class_2769)RedstoneLinkBlock.RECEIVER), true);
        scene.idle(10);
        scene.overlay.showText(50).text("A simple Right-click with a Wrench can do the same").placeNearTarget().pointAt(link3Vec);
        scene.idle(70);
        scene.addKeyframe();
        scene.idle(10);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(5);
        scene.world.toggleRedstonePower(util.select.fromTo(3, 2, 3, 1, 2, 2));
        scene.effects.indicateRedstone(link2Pos);
        scene.effects.indicateRedstone(link3Pos);
        scene.idle(10);
        scene.overlay.showText(70).colored(PonderPalette.GREEN).text("Receivers emit the redstone power of transmitters within 128 blocks").placeNearTarget().pointAt(link2Vec);
        scene.idle(80);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(5);
        scene.world.toggleRedstonePower(util.select.fromTo(3, 2, 3, 1, 2, 2));
        scene.idle(20);
        class_243 frontSlot = link1Vec.method_1031(0.18, -0.05, -0.15);
        class_243 backSlot = link1Vec.method_1031(0.18, -0.05, 0.15);
        class_243 top2Slot = link2Vec.method_1031(-0.09, 0.15, 0.0);
        class_243 bottom2Slot = link2Vec.method_1031(-0.09, -0.2, 0.0);
        class_243 top3Slot = link3Vec.method_1031(-0.09, 0.15, 0.0);
        class_243 bottom3Slot = link3Vec.method_1031(-0.09, -0.2, 0.0);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay.showFilterSlotInput(frontSlot, 100);
        scene.overlay.showFilterSlotInput(backSlot, 100);
        scene.idle(10);
        scene.overlay.showText(50).text("Placing items in the two slots can specify a Frequency").placeNearTarget().pointAt(backSlot);
        scene.idle(60);
        class_1799 iron = new class_1799((class_1935)class_1802.field_8620);
        class_1799 gold = new class_1799((class_1935)class_1802.field_8695);
        class_1799 sapling = new class_1799((class_1935)class_1802.field_17535);
        scene.overlay.showControls(new InputWindowElement(backSlot, Pointing.DOWN).withItem(iron), 40);
        scene.idle(7);
        scene.overlay.showControls(new InputWindowElement(frontSlot, Pointing.UP).withItem(sapling), 40);
        scene.world.modifyTileNBT(link1Select, RedstoneLinkTileEntity.class, nbt -> nbt.method_10566("FrequencyLast", (class_2520)iron.method_7953(new class_2487())));
        scene.idle(7);
        scene.world.modifyTileNBT(link1Select, RedstoneLinkTileEntity.class, nbt -> nbt.method_10566("FrequencyFirst", (class_2520)sapling.method_7953(new class_2487())));
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(top2Slot, Pointing.DOWN).withItem(iron), 40);
        scene.idle(7);
        scene.overlay.showControls(new InputWindowElement(bottom2Slot, Pointing.UP).withItem(sapling), 40);
        scene.world.modifyTileNBT(link2Select, RedstoneLinkTileEntity.class, nbt -> nbt.method_10566("FrequencyLast", (class_2520)iron.method_7953(new class_2487())));
        scene.idle(7);
        scene.world.modifyTileNBT(link2Select, RedstoneLinkTileEntity.class, nbt -> nbt.method_10566("FrequencyFirst", (class_2520)sapling.method_7953(new class_2487())));
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(top3Slot, Pointing.DOWN).withItem(gold), 40);
        scene.idle(7);
        scene.overlay.showControls(new InputWindowElement(bottom3Slot, Pointing.UP).withItem(sapling), 40);
        scene.world.modifyTileNBT(link3Select, RedstoneLinkTileEntity.class, nbt -> nbt.method_10566("FrequencyLast", (class_2520)gold.method_7953(new class_2487())));
        scene.idle(7);
        scene.world.modifyTileNBT(link3Select, RedstoneLinkTileEntity.class, nbt -> nbt.method_10566("FrequencyFirst", (class_2520)sapling.method_7953(new class_2487())));
        scene.idle(20);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(5);
        scene.world.toggleRedstonePower(util.select.fromTo(1, 2, 2, 1, 2, 3));
        scene.effects.indicateRedstone(link2Pos);
        scene.overlay.showText(90).attachKeyFrame().text("Only the links with matching Frequencies will communicate").placeNearTarget().pointAt(link2Vec);
        scene.idle(100);
    }

    private static /* synthetic */ void lambda$nixieTube$19(class_2561 component, int index, class_2487 nbt) {
        nbt.method_10582("RawCustomText", component.getString());
        nbt.method_10582("CustomText", class_2561.class_2562.method_10867((class_2561)component));
        nbt.method_10569("CustomTextIndex", index);
    }
}

