/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.belt;

import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class BeltProcessingBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<BeltProcessingBehaviour> TYPE = new BehaviourType();
    private ProcessingCallback onItemEnter = (s, i) -> ProcessingResult.PASS;
    private ProcessingCallback continueProcessing = (s, i) -> ProcessingResult.PASS;

    public BeltProcessingBehaviour(SmartTileEntity te) {
        super(te);
    }

    public BeltProcessingBehaviour whenItemEnters(ProcessingCallback callback) {
        this.onItemEnter = callback;
        return this;
    }

    public BeltProcessingBehaviour whileItemHeld(ProcessingCallback callback) {
        this.continueProcessing = callback;
        return this;
    }

    public static boolean isBlocked(class_1922 world, class_2338 processingSpace) {
        class_2680 blockState = world.method_8320(processingSpace.method_10084());
        if (AbstractFunnelBlock.isFunnel(blockState)) {
            return false;
        }
        return !blockState.method_26220(world, processingSpace.method_10084()).method_1110();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public ProcessingResult handleReceivedItem(TransportedItemStack stack, TransportedItemStackHandlerBehaviour inventory) {
        return this.onItemEnter.apply(stack, inventory);
    }

    public ProcessingResult handleHeldItem(TransportedItemStack stack, TransportedItemStackHandlerBehaviour inventory) {
        return this.continueProcessing.apply(stack, inventory);
    }

    @FunctionalInterface
    public static interface ProcessingCallback {
        public ProcessingResult apply(TransportedItemStack var1, TransportedItemStackHandlerBehaviour var2);
    }

    public static enum ProcessingResult {
        PASS,
        HOLD,
        REMOVE;

    }
}

