/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.api;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.builders.lodBuilding.LodBuilder;
import com.seibel.lod.core.builders.worldGeneration.BatchGenerator;
import com.seibel.lod.core.enums.WorldType;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.render.GLProxy;
import com.seibel.lod.core.render.LodRenderer;
import com.seibel.lod.core.util.DetailDistanceUtil;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.IVersionConstants;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;

public class EventApi {
    public static final boolean ENABLE_STACK_DUMP_LOGGING = false;
    public static final EventApi INSTANCE = new EventApi();
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final IVersionConstants VERSION_CONSTANTS = SingletonHandler.get(IVersionConstants.class);
    private boolean recalculateWidths = false;
    private boolean isCurrentlyOnSinglePlayerServer = false;
    public BatchGenerator batchGenerator = null;
    private int lastWorldGenTickDelta = 0;

    private EventApi() {
    }

    public void serverTickEvent() {
        --this.lastWorldGenTickDelta;
        if (!MC.playerExists() || ApiShared.lodWorld.getIsWorldNotLoaded()) {
            return;
        }
        LodDimension lodDim = ApiShared.lodWorld.getLodDimension(MC.getCurrentDimension());
        if (lodDim == null) {
            return;
        }
        if (ApiShared.isShuttingDown) {
            return;
        }
        if (CONFIG.client().worldGenerator().getEnableDistantGeneration()) {
            if (this.lastWorldGenTickDelta <= 0) {
                this.lastWorldGenTickDelta = 20;
                try {
                    if (this.batchGenerator == null) {
                        this.batchGenerator = new BatchGenerator(ApiShared.lodBuilder, lodDim);
                    }
                    this.batchGenerator.queueGenerationRequests(lodDim, ApiShared.lodBuilder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this.batchGenerator != null) {
            this.batchGenerator.stop(false);
            this.batchGenerator = null;
        }
    }

    public void worldSaveEvent() {
        ApiShared.lodWorld.saveAllDimensions(false);
    }

    public void worldLoadEvent(IWorldWrapper world) {
        if (world.getWorldType() == WorldType.ServerWorld) {
            return;
        }
        this.isCurrentlyOnSinglePlayerServer = MC.hasSinglePlayerServer();
        if (!ApiShared.isShuttingDown) {
            ApiShared.LOGGER.warn("WorldLoadEvent called on {} while another world is loaded!", (Object)(world.getWorldType() == WorldType.ClientWorld ? "clientLevel" : "serverLevel"));
        }
        ApiShared.isShuttingDown = false;
        LodBuilder.MIN_WORLD_HEIGHT = world.getMinHeight();
        String worldID = LodUtil.getWorldID(world);
        ApiShared.LOGGER.info("Loading new world/dimension: {}", (Object)worldID);
        ApiShared.lodWorld.selectWorld(worldID);
        ApiShared.LOGGER.info("World/dimension loaded: {}", (Object)worldID);
        ClientApi.renderer.regenerateLODsNextFrame();
        ApiShared.previousVertQual = CONFIG.client().graphics().quality().getVerticalQuality();
    }

    public void worldUnloadEvent(IWorldWrapper world) {
        if (this.isCurrentlyOnSinglePlayerServer && world.getWorldType() == WorldType.ClientWorld) {
            return;
        }
        if (ApiShared.isShuttingDown) {
            return;
        }
        ApiShared.isShuttingDown = true;
        if (this.batchGenerator != null) {
            this.batchGenerator.stop(true);
        }
        this.batchGenerator = null;
        ApiShared.lodWorld.deselectWorld();
        ClientApi.renderer.destroyBuffers();
        ClientApi.renderer.requestCleanup();
        GLProxy.ensureAllGLJobCompleted();
        this.recalculateWidths = true;
        ApiShared.previousVertQual = null;
        ClientApi.renderer = new LodRenderer(ClientApi.lodBufferBuilderFactory);
        ClientApi.INSTANCE.rendererDisabledBecauseOfExceptions = false;
        ApiShared.LOGGER.info("Distant Horizon unloaded");
    }

    public void blockChangeEvent(IChunkWrapper chunk, IDimensionTypeWrapper dimType) {
        if (dimType != MC.getCurrentDimension()) {
            return;
        }
        ClientApi.LagSpikeCatcher blockChangeUpdate = new ClientApi.LagSpikeCatcher();
        ClientApi.INSTANCE.toBeLoaded.add(chunk.getLongChunkPos());
        blockChangeUpdate.end("clientChunkLoad");
    }

    public void playerMoveEvent(LodDimension lodDim) {
        RegionPos playerRegionPos = new RegionPos(MC.getPlayerBlockPos());
        RegionPos center = lodDim.getCenterRegionPos();
        RegionPos worldRegionOffset = new RegionPos(playerRegionPos.x - center.x, playerRegionPos.z - center.z);
        if (worldRegionOffset.x != 0 || worldRegionOffset.z != 0) {
            lodDim.move(worldRegionOffset);
        }
    }

    public void viewDistanceChangedEvent() {
        int chunksWide = MC.getWrappedClientWorld().getDimensionType().hasCeiling() ? Math.min(CONFIG.client().graphics().quality().getLodChunkRenderDistance(), 64) * 2 + 1 : CONFIG.client().graphics().quality().getLodChunkRenderDistance() * 2 + 1;
        int newWidth = (int)Math.ceil((float)chunksWide / 32.0f);
        if (ApiShared.lodBuilder.defaultDimensionWidthInRegions != (newWidth += (newWidth & 1) == 0 ? 1 : 0) || this.recalculateWidths) {
            ApiShared.lodWorld.resizeDimensionRegionWidth(newWidth);
            ApiShared.lodBuilder.defaultDimensionWidthInRegions = newWidth;
            ClientApi.renderer.setupBuffers();
            this.recalculateWidths = false;
        }
        DetailDistanceUtil.updateSettings();
    }
}

