/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.builders.worldGeneration;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.builders.lodBuilding.LodBuilder;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.config.GenerationPriority;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.PosToGenerateContainer;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import com.seibel.lod.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvionmentWrapper;

public class BatchGenerator {
    public static final boolean ENABLE_GENERATOR_STATS_LOGGING = false;
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final IWrapperFactory FACTORY = SingletonHandler.get(IWrapperFactory.class);
    public AbstractBatchGenerationEnvionmentWrapper generationGroup;
    public LodDimension targetLodDim;
    public static final int generationGroupSize = 4;
    public static int previousThreadCount = CONFIG.client().advanced().threading()._getWorldGenerationThreadPoolSize();
    private int estimatedSampleNeeded = 128;
    private int estimatedPointsToQueue = 1;

    public BatchGenerator(LodBuilder newLodBuilder, LodDimension newLodDimension) {
        IWorldWrapper world = LodUtil.getServerWorldFromDimension(newLodDimension.dimension);
        this.targetLodDim = newLodDimension;
        this.generationGroup = FACTORY.createBatchGenerator(newLodBuilder, newLodDimension, world);
        MC.sendChatMessage("NOTE: You are currently using Distant Horizon's Batch Chunk Pre-Generator.");
        ApiShared.LOGGER.info("Batch Chunk Generator initialized");
    }

    public void queueGenerationRequests(LodDimension lodDim, LodBuilder lodBuilder) {
        AbstractBatchGenerationEnvionmentWrapper.Steps targetStep;
        int targetToGenerate;
        GenerationPriority priority;
        if (lodDim != this.targetLodDim) {
            this.stop(false);
            IWorldWrapper dim = LodUtil.getServerWorldFromDimension(lodDim.dimension);
            this.generationGroup = FACTORY.createBatchGenerator(lodBuilder, lodDim, dim);
            this.targetLodDim = lodDim;
            ApiShared.LOGGER.info("1.18 Experimental Chunk Generator reinitialized");
        }
        DistanceGenerationMode mode = CONFIG.client().worldGenerator().getDistanceGenerationMode();
        int newThreadCount = CONFIG.client().advanced().threading()._getWorldGenerationThreadPoolSize();
        if (newThreadCount != previousThreadCount) {
            this.generationGroup.resizeThreadPool(newThreadCount);
            previousThreadCount = newThreadCount;
        }
        if (this.estimatedPointsToQueue < newThreadCount) {
            this.estimatedPointsToQueue = newThreadCount;
        }
        if ((priority = CONFIG.client().worldGenerator().getGenerationPriority()) == GenerationPriority.AUTO) {
            priority = MC.hasSinglePlayerServer() ? GenerationPriority.FAR_FIRST : GenerationPriority.NEAR_FIRST;
        }
        this.generationGroup.updateAllFutures();
        if (!MC.hasSinglePlayerServer()) {
            return;
        }
        if (!LodUtil.checkRamUsage(0.1, 64)) {
            return;
        }
        int eventsCount = this.generationGroup.getEventCount();
        if (eventsCount >= this.estimatedPointsToQueue) {
            --this.estimatedPointsToQueue;
            if (this.estimatedPointsToQueue < newThreadCount) {
                this.estimatedPointsToQueue = newThreadCount;
            }
            return;
        }
        int toGenerate = targetToGenerate = this.estimatedPointsToQueue - eventsCount;
        int positionGoneThough = 0;
        int playerPosX = MC.getPlayerBlockPos().getX();
        int playerPosZ = MC.getPlayerBlockPos().getZ();
        double runTimeRatio = CONFIG.client().advanced().threading()._getWorldGenerationPartialRunTime();
        PosToGenerateContainer posToGenerate = lodDim.getPosToGenerate(this.estimatedSampleNeeded, playerPosX, playerPosZ, priority, mode);
        if (eventsCount == 0 && posToGenerate.getNumberOfPos() >= this.estimatedSampleNeeded) {
            ++this.estimatedPointsToQueue;
            if (this.estimatedPointsToQueue > newThreadCount * 10) {
                this.estimatedPointsToQueue = newThreadCount * 10;
            }
        }
        switch (mode) {
            case NONE: {
                targetStep = AbstractBatchGenerationEnvionmentWrapper.Steps.Empty;
                break;
            }
            case BIOME_ONLY: {
                targetStep = AbstractBatchGenerationEnvionmentWrapper.Steps.Biomes;
                break;
            }
            case BIOME_ONLY_SIMULATE_HEIGHT: {
                targetStep = AbstractBatchGenerationEnvionmentWrapper.Steps.Noise;
                break;
            }
            case SURFACE: {
                targetStep = AbstractBatchGenerationEnvionmentWrapper.Steps.Surface;
                break;
            }
            case FEATURES: 
            case FULL: {
                targetStep = AbstractBatchGenerationEnvionmentWrapper.Steps.Features;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (priority == GenerationPriority.FAR_FIRST || priority == GenerationPriority.BALANCED) {
            int nearCount = posToGenerate.getNumberOfNearPos();
            int farCount = posToGenerate.getNumberOfFarPos();
            int maxIteration = Math.max(nearCount, farCount);
            for (int i = 0; i < maxIteration; ++i) {
                int genSize;
                int chunkZ;
                int chunkX;
                byte detailLevel;
                if (i < farCount && posToGenerate.getNthDetail(i, false) != 0) {
                    ++positionGoneThough;
                    detailLevel = (byte)(posToGenerate.getNthDetail(i, false) - 1);
                    chunkX = LevelPosUtil.getChunkPos(detailLevel, posToGenerate.getNthPosX(i, false));
                    chunkZ = LevelPosUtil.getChunkPos(detailLevel, posToGenerate.getNthPosZ(i, false));
                    int n = genSize = detailLevel > 4 ? 0 : 4;
                    if (this.generationGroup.tryAddPoint(chunkX, chunkZ, genSize, targetStep, false, runTimeRatio)) {
                        --toGenerate;
                    }
                }
                if (toGenerate <= 0) break;
                if (i < nearCount && posToGenerate.getNthDetail(i, true) != 0) {
                    ++positionGoneThough;
                    detailLevel = (byte)(posToGenerate.getNthDetail(i, true) - 1);
                    chunkX = LevelPosUtil.getChunkPos(detailLevel, posToGenerate.getNthPosX(i, true));
                    chunkZ = LevelPosUtil.getChunkPos(detailLevel, posToGenerate.getNthPosZ(i, true));
                    int n = genSize = detailLevel > 4 ? 0 : 4;
                    if (this.generationGroup.tryAddPoint(chunkX, chunkZ, genSize, targetStep, true, runTimeRatio)) {
                        --toGenerate;
                    }
                }
                if (toGenerate > 0) {
                    continue;
                }
                break;
            }
        } else {
            int nearCount = posToGenerate.getNumberOfNearPos();
            for (int i = 0; i < nearCount; ++i) {
                int genSize;
                if (posToGenerate.getNthDetail(i, true) == 0) continue;
                ++positionGoneThough;
                byte detailLevel = (byte)(posToGenerate.getNthDetail(i, true) - 1);
                int chunkX = LevelPosUtil.getChunkPos(detailLevel, posToGenerate.getNthPosX(i, true));
                int chunkZ = LevelPosUtil.getChunkPos(detailLevel, posToGenerate.getNthPosZ(i, true));
                int n = genSize = detailLevel > 4 ? 0 : 4;
                if (this.generationGroup.tryAddPoint(chunkX, chunkZ, genSize, targetStep, true, runTimeRatio)) {
                    --toGenerate;
                }
                if (toGenerate <= 0) break;
            }
            if (toGenerate > 0 && this.estimatedSampleNeeded > posToGenerate.getNumberOfPos()) {
                int farCount = posToGenerate.getNumberOfFarPos();
                for (int i = 0; i < farCount; ++i) {
                    if (posToGenerate.getNthDetail(i, false) != 0) {
                        int genSize;
                        ++positionGoneThough;
                        byte detailLevel = (byte)(posToGenerate.getNthDetail(i, false) - 1);
                        int chunkX = LevelPosUtil.getChunkPos(detailLevel, posToGenerate.getNthPosX(i, false));
                        int chunkZ = LevelPosUtil.getChunkPos(detailLevel, posToGenerate.getNthPosZ(i, false));
                        int n = genSize = detailLevel > 4 ? 0 : 4;
                        if (this.generationGroup.tryAddPoint(chunkX, chunkZ, genSize, targetStep, false, runTimeRatio)) {
                            --toGenerate;
                        }
                    }
                    if (toGenerate > 0) {
                        continue;
                    }
                    break;
                }
            }
        }
        if (targetToGenerate != toGenerate) {
            // empty if block
        }
        if (toGenerate > 0 && this.estimatedSampleNeeded <= posToGenerate.getNumberOfPos()) {
            this.estimatedSampleNeeded = (int)((double)this.estimatedSampleNeeded * 1.3);
            if (this.estimatedSampleNeeded > 32768) {
                this.estimatedSampleNeeded = 32768;
            }
        } else if (toGenerate <= 0 && (double)positionGoneThough * 1.5 < (double)posToGenerate.getNumberOfPos()) {
            this.estimatedSampleNeeded = (int)((double)this.estimatedSampleNeeded / 1.2);
            if (this.estimatedSampleNeeded < 4) {
                this.estimatedSampleNeeded = 4;
            }
        }
    }

    public void stop(boolean blocking) {
        ApiShared.LOGGER.info("1.18 Experimental Chunk Generator shutting down...");
        this.generationGroup.stop(blocking);
    }
}

