/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.opengl;

import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodQuadBuilder;
import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.util.ColorUtil;
import com.seibel.lod.core.util.DataPointUtil;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;

public class LodBox {
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);

    public static void addBoxQuadsToBuilder(LodQuadBuilder builder, short xSize, short ySize, short zSize, short x, short y, short z, int color, byte skyLight, byte blockLight, long topData, long botData, long[][][] adjData, boolean[] adjFillBlack) {
        int adjOverlapEast;
        int adjOverlapWest;
        int adjOverlapSouth;
        int adjOverlapNorth;
        boolean skipBot;
        short maxX = (short)(x + xSize);
        short maxY = (short)(y + ySize);
        short maxZ = (short)(z + zSize);
        byte skyLightTop = skyLight;
        byte skyLightBot = DataPointUtil.doesItExist(botData) ? DataPointUtil.getLightSky(botData) : (byte)0;
        boolean skipTop = DataPointUtil.doesItExist(topData) && DataPointUtil.getDepth(topData) == maxY;
        boolean bl = skipBot = DataPointUtil.doesItExist(botData) && DataPointUtil.getHeight(botData) == y;
        if (!skipTop) {
            builder.addQuadUp(x, maxY, z, xSize, zSize, ColorUtil.applyShade(color, MC.getShade(LodDirection.UP)), skyLightTop, blockLight);
        }
        if (!skipBot) {
            builder.addQuadDown(x, y, z, xSize, zSize, ColorUtil.applyShade(color, MC.getShade(LodDirection.DOWN)), skyLightBot, blockLight);
        }
        long[][] adjDataNorth = adjData[LodDirection.NORTH.ordinal() - 2];
        int n = adjOverlapNorth = adjFillBlack[LodDirection.NORTH.ordinal() - 2] ? ColorUtil.BLACK : ColorUtil.TRANSPARENT;
        if (adjDataNorth == null) {
            builder.addQuadAdj(LodDirection.NORTH, x, y, z, xSize, ySize, color, (byte)15, blockLight);
        } else if (adjDataNorth.length == 1) {
            LodBox.makeAdjQuads(builder, adjDataNorth[0], LodDirection.NORTH, x, y, z, xSize, ySize, color, adjOverlapNorth, skyLightTop, blockLight);
        } else {
            LodBox.makeAdjQuads(builder, adjDataNorth[0], LodDirection.NORTH, x, y, z, (short)(xSize / 2), ySize, color, adjOverlapNorth, skyLightTop, blockLight);
            LodBox.makeAdjQuads(builder, adjDataNorth[1], LodDirection.NORTH, (short)(x + xSize / 2), y, z, (short)(xSize / 2), ySize, color, adjOverlapNorth, skyLightTop, blockLight);
        }
        long[][] adjDataSouth = adjData[LodDirection.SOUTH.ordinal() - 2];
        int n2 = adjOverlapSouth = adjFillBlack[LodDirection.SOUTH.ordinal() - 2] ? ColorUtil.BLACK : ColorUtil.TRANSPARENT;
        if (adjDataSouth == null) {
            builder.addQuadAdj(LodDirection.SOUTH, x, y, maxZ, xSize, ySize, color, (byte)15, blockLight);
        } else if (adjDataSouth.length == 1) {
            LodBox.makeAdjQuads(builder, adjDataSouth[0], LodDirection.SOUTH, x, y, maxZ, xSize, ySize, color, adjOverlapSouth, skyLightTop, blockLight);
        } else {
            LodBox.makeAdjQuads(builder, adjDataSouth[0], LodDirection.SOUTH, x, y, maxZ, (short)(xSize / 2), ySize, color, adjOverlapSouth, skyLightTop, blockLight);
            LodBox.makeAdjQuads(builder, adjDataSouth[1], LodDirection.SOUTH, (short)(x + xSize / 2), y, maxZ, (short)(xSize / 2), ySize, color, adjOverlapSouth, skyLightTop, blockLight);
        }
        long[][] adjDataWest = adjData[LodDirection.WEST.ordinal() - 2];
        int n3 = adjOverlapWest = adjFillBlack[LodDirection.WEST.ordinal() - 2] ? ColorUtil.BLACK : ColorUtil.TRANSPARENT;
        if (adjDataWest == null) {
            builder.addQuadAdj(LodDirection.WEST, x, y, z, zSize, ySize, color, (byte)15, blockLight);
        } else if (adjDataWest.length == 1) {
            LodBox.makeAdjQuads(builder, adjDataWest[0], LodDirection.WEST, x, y, z, zSize, ySize, color, adjOverlapWest, skyLightTop, blockLight);
        } else {
            LodBox.makeAdjQuads(builder, adjDataWest[0], LodDirection.WEST, x, y, z, (short)(zSize / 2), ySize, color, adjOverlapWest, skyLightTop, blockLight);
            LodBox.makeAdjQuads(builder, adjDataWest[1], LodDirection.WEST, x, y, (short)(z + zSize / 2), (short)(zSize / 2), ySize, color, adjOverlapWest, skyLightTop, blockLight);
        }
        long[][] adjDataEast = adjData[LodDirection.EAST.ordinal() - 2];
        int n4 = adjOverlapEast = adjFillBlack[LodDirection.EAST.ordinal() - 2] ? ColorUtil.BLACK : ColorUtil.TRANSPARENT;
        if (adjData[LodDirection.EAST.ordinal() - 2] == null) {
            builder.addQuadAdj(LodDirection.EAST, maxX, y, z, zSize, ySize, color, (byte)15, blockLight);
        } else if (adjDataEast.length == 1) {
            LodBox.makeAdjQuads(builder, adjDataEast[0], LodDirection.EAST, maxX, y, z, zSize, ySize, color, adjOverlapEast, skyLightTop, blockLight);
        } else {
            LodBox.makeAdjQuads(builder, adjDataEast[0], LodDirection.EAST, maxX, y, z, (short)(zSize / 2), ySize, color, adjOverlapEast, skyLightTop, blockLight);
            LodBox.makeAdjQuads(builder, adjDataEast[1], LodDirection.EAST, maxX, y, (short)(z + zSize / 2), (short)(zSize / 2), ySize, color, adjOverlapEast, skyLightTop, blockLight);
        }
    }

    private static void makeAdjQuads(LodQuadBuilder builder, long[] adjData, LodDirection direction, short x, short y, short z, short w0, short wy, int color, int overlapColor, byte upSkyLight, byte blockLight) {
        color = ColorUtil.applyShade(color, MC.getShade(direction));
        long[] dataPoint = adjData;
        if (dataPoint == null || DataPointUtil.isVoid(dataPoint[0])) {
            builder.addQuadAdj(direction, x, y, z, w0, wy, color, (byte)15, blockLight);
            return;
        }
        boolean firstFace = true;
        boolean allAbove = true;
        short previousDepth = -1;
        byte nextSkyLight = upSkyLight;
        for (int i = 0; i < dataPoint.length && DataPointUtil.doesItExist(adjData[i]) && !DataPointUtil.isVoid(adjData[i]); ++i) {
            long adjPoint = adjData[i];
            short height = DataPointUtil.getHeight(adjPoint);
            short depth = DataPointUtil.getDepth(adjPoint);
            if (y + wy <= depth) continue;
            allAbove = false;
            if (height < y) {
                if (firstFace) {
                    builder.addQuadAdj(direction, x, y, z, w0, wy, color, DataPointUtil.getLightSky(adjPoint), blockLight);
                    break;
                }
                if (previousDepth == -1) {
                    throw new RuntimeException("Loop error");
                }
                builder.addQuadAdj(direction, x, y, z, w0, (short)(previousDepth - y), color, DataPointUtil.getLightSky(adjPoint), blockLight);
                previousDepth = -1;
                break;
            }
            if (depth <= y) {
                if (y + wy <= height) {
                    if (overlapColor == 0) break;
                    builder.addQuadAdj(direction, x, y, z, w0, wy, overlapColor, (byte)15, (byte)15);
                    break;
                }
                if (height > y && overlapColor != 0) {
                    builder.addQuadAdj(direction, x, y, z, w0, (short)(height - y), overlapColor, (byte)15, (byte)15);
                }
                if (firstFace) {
                    builder.addQuadAdj(direction, x, height, z, w0, (short)(y + wy - height), color, DataPointUtil.getLightSky(adjPoint), blockLight);
                    break;
                }
                if (previousDepth == -1) {
                    throw new RuntimeException("Loop error");
                }
                if (previousDepth > height) {
                    builder.addQuadAdj(direction, x, height, z, w0, (short)(previousDepth - height), color, DataPointUtil.getLightSky(adjPoint), blockLight);
                }
                previousDepth = -1;
                break;
            }
            if (y + wy <= height) {
                if (overlapColor != 0) {
                    builder.addQuadAdj(direction, x, depth, z, w0, (short)(y + wy - depth), overlapColor, (byte)15, (byte)15);
                }
            } else {
                if (overlapColor != 0) {
                    builder.addQuadAdj(direction, x, depth, z, w0, (short)(height - depth), overlapColor, (byte)15, (byte)15);
                }
                if (firstFace) {
                    builder.addQuadAdj(direction, x, height, z, w0, (short)(y + wy - height), color, DataPointUtil.getLightSky(adjPoint), blockLight);
                } else {
                    if (previousDepth == -1) {
                        throw new RuntimeException("Loop error");
                    }
                    if (previousDepth > height) {
                        builder.addQuadAdj(direction, x, height, z, w0, (short)(previousDepth - height), color, DataPointUtil.getLightSky(adjPoint), blockLight);
                    }
                    previousDepth = -1;
                }
            }
            previousDepth = depth;
            firstFace = false;
            nextSkyLight = upSkyLight;
            if (i + 1 >= adjData.length || !DataPointUtil.doesItExist(adjData[i + 1])) continue;
            nextSkyLight = DataPointUtil.getLightSky(adjData[i + 1]);
        }
        if (allAbove) {
            builder.addQuadAdj(direction, x, y, z, w0, wy, color, upSkyLight, blockLight);
        } else if (previousDepth != -1) {
            builder.addQuadAdj(direction, x, y, z, w0, (short)(previousDepth - y), color, nextSkyLight, blockLight);
        }
    }
}

