/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.opengl;

import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodQuadBuilder;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.render.LodRenderProgram;
import com.seibel.lod.core.util.StatsMap;
import java.util.ConcurrentModificationException;

public abstract class RenderBuffer
implements AutoCloseable {
    private State owner = State.None;
    private State nextOwner = State.None;

    private final void _lockThread(State newOwner) {
        if (this.owner != State.None || this.nextOwner != State.None && this.nextOwner != newOwner) {
            throw new ConcurrentModificationException("RenderMethod Illegal state!");
        }
        this.owner = newOwner;
        this.nextOwner = State.None;
    }

    private final void _unlockThread(State oldOwner) {
        if (this.owner != oldOwner) {
            throw new ConcurrentModificationException("RenderMethod Illegal state!");
        }
        this.owner = State.None;
    }

    private final void _unlockThreadTo(State oldOwner, State newOwner) {
        if (this.owner != oldOwner) {
            throw new ConcurrentModificationException("RenderMethod Illegal state!");
        }
        this.owner = State.None;
        this.nextOwner = newOwner;
    }

    public final void build(Runnable r) {
        this._lockThread(State.Building);
        try {
            r.run();
        }
        finally {
            this._unlockThread(State.Building);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryUploadBuffers(LodQuadBuilder builder, GpuUploadMethod uploadMethod) {
        this._lockThread(State.Uploading);
        boolean successful = false;
        try {
            boolean bl = successful = this.uploadBuffers(builder, uploadMethod);
            return bl;
        }
        finally {
            if (!successful) {
                this._unlockThreadTo(State.Uploading, State.Closed);
                this.close();
            } else {
                this._unlockThread(State.Uploading);
            }
        }
    }

    public void onReuse() {
    }

    protected abstract boolean uploadBuffers(LodQuadBuilder var1, GpuUploadMethod var2);

    public void onSwapToFront() {
    }

    public boolean onSwapToBack() {
        return true;
    }

    public abstract boolean render(LodRenderProgram var1);

    public abstract void debugDumpStats(StatsMap var1);

    @Override
    public abstract void close();

    private static enum State {
        None,
        Building,
        Uploading,
        Closed;

    }
}

