/*
 * Decompiled with CFR 0.152.
 */
package shaded.electronwill.nightconfig.toml;

import java.time.temporal.Temporal;
import java.util.Map;
import java.util.function.Supplier;
import shaded.electronwill.nightconfig.core.CommentedConfig;
import shaded.electronwill.nightconfig.core.ConfigFormat;
import shaded.electronwill.nightconfig.core.file.FormatDetector;
import shaded.electronwill.nightconfig.toml.TomlParser;
import shaded.electronwill.nightconfig.toml.TomlWriter;

public final class TomlFormat
implements ConfigFormat<CommentedConfig> {
    private static final TomlFormat INSTANCE = new TomlFormat();

    public static TomlFormat instance() {
        return INSTANCE;
    }

    public static CommentedConfig newConfig() {
        return (CommentedConfig)INSTANCE.createConfig();
    }

    public static CommentedConfig newConfig(Supplier<Map<String, Object>> s) {
        return INSTANCE.createConfig((Supplier)s);
    }

    public static CommentedConfig newConcurrentConfig() {
        return (CommentedConfig)INSTANCE.createConcurrentConfig();
    }

    private TomlFormat() {
    }

    @Override
    public TomlWriter createWriter() {
        return new TomlWriter();
    }

    public TomlParser createParser() {
        return new TomlParser();
    }

    @Override
    public CommentedConfig createConfig(Supplier<Map<String, Object>> mapCreator) {
        return CommentedConfig.of(mapCreator, this);
    }

    @Override
    public boolean supportsComments() {
        return true;
    }

    @Override
    public boolean supportsType(Class<?> type) {
        return ConfigFormat.super.supportsType(type) || Temporal.class.isAssignableFrom(type);
    }

    static {
        FormatDetector.registerExtension("toml", INSTANCE);
    }
}

