/*
 * Decompiled with CFR 0.152.
 */
package me.andrew.gravitychanger.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import me.andrew.gravitychanger.accessor.RotatableEntityAccessor;
import me.andrew.gravitychanger.util.RotationUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

public class GravityCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literalSet = class_2170.method_9247((String)"set");
        for (class_2350 direction : class_2350.values()) {
            literalSet.then(((LiteralArgumentBuilder)class_2170.method_9247((String)direction.method_10151()).executes(context -> GravityCommand.executeSet((class_2168)context.getSource(), direction, Collections.singleton(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> GravityCommand.executeSet((class_2168)context.getSource(), direction, class_2186.method_9312((CommandContext)context, (String)"players")))));
        }
        LiteralArgumentBuilder literalRotate = class_2170.method_9247((String)"rotate");
        for (FacingDirection facingDirection : FacingDirection.values()) {
            literalRotate.then(((LiteralArgumentBuilder)class_2170.method_9247((String)facingDirection.getName()).executes(context -> GravityCommand.executeRotate((class_2168)context.getSource(), facingDirection, Collections.singleton(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> GravityCommand.executeRotate((class_2168)context.getSource(), facingDirection, class_2186.method_9312((CommandContext)context, (String)"players")))));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"gravity").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(context -> GravityCommand.executeGet((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> GravityCommand.executeGet((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then((ArgumentBuilder)literalSet)).then((ArgumentBuilder)literalRotate)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"randomise").executes(context -> GravityCommand.executeRandomise((class_2168)context.getSource(), Collections.singleton(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> GravityCommand.executeRandomise((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"players"))))));
    }

    private static int executeGet(class_2168 source, class_3222 player) {
        class_2350 gravityDirection = ((RotatableEntityAccessor)player).gravitychanger$getGravityDirection();
        GravityCommand.getSendFeedback(source, player, gravityDirection);
        return gravityDirection.method_10146();
    }

    private static void getSendFeedback(class_2168 source, class_3222 player, class_2350 gravityDirection) {
        class_2588 text = new class_2588("direction." + gravityDirection.method_10151());
        if (source.method_9228() == player) {
            source.method_9226((class_2561)new class_2588("commands.gravity.get.self", new Object[]{text}), true);
        } else {
            source.method_9226((class_2561)new class_2588("commands.gravity.get.other", new Object[]{player.method_5476(), text}), true);
        }
    }

    private static int executeSet(class_2168 source, class_2350 gravityDirection, Collection<class_3222> players) {
        int i = 0;
        for (class_3222 player : players) {
            RotatableEntityAccessor rotatableEntityAccessor = (RotatableEntityAccessor)player;
            if (rotatableEntityAccessor.gravitychanger$getGravityDirection() == gravityDirection) continue;
            rotatableEntityAccessor.gravitychanger$setGravityDirection(gravityDirection, false);
            GravityCommand.setSendFeedback(source, player, gravityDirection);
            ++i;
        }
        return i;
    }

    private static void setSendFeedback(class_2168 source, class_3222 player, class_2350 gravityDirection) {
        class_2588 text = new class_2588("direction." + gravityDirection.method_10151());
        if (source.method_9228() == player) {
            source.method_9226((class_2561)new class_2588("commands.gravity.set.self", new Object[]{text}), true);
        } else {
            source.method_9226((class_2561)new class_2588("commands.gravity.set.other", new Object[]{player.method_5476(), text}), true);
        }
    }

    private static int executeRotate(class_2168 source, FacingDirection relativeDirection, Collection<class_3222> players) {
        int i = 0;
        for (class_3222 player : players) {
            RotatableEntityAccessor rotatableEntityAccessor = (RotatableEntityAccessor)player;
            class_2350 gravityDirection = rotatableEntityAccessor.gravitychanger$getGravityDirection();
            class_2350 combinedRelativeDirection = switch (relativeDirection) {
                default -> throw new IncompatibleClassChangeError();
                case FacingDirection.DOWN -> class_2350.field_11033;
                case FacingDirection.UP -> class_2350.field_11036;
                case FacingDirection.FORWARD, FacingDirection.BACKWARD, FacingDirection.LEFT, FacingDirection.RIGHT -> class_2350.method_10139((int)(relativeDirection.getHorizontalOffset() + class_2350.method_10150((double)player.method_36454()).method_10161()));
            };
            class_2350 newGravityDirection = RotationUtil.dirPlayerToWorld(combinedRelativeDirection, gravityDirection);
            rotatableEntityAccessor.gravitychanger$setGravityDirection(newGravityDirection, false);
            GravityCommand.setSendFeedback(source, player, newGravityDirection);
            ++i;
        }
        return i;
    }

    private static int executeRandomise(class_2168 source, Collection<class_3222> players) {
        int i = 0;
        for (class_3222 player : players) {
            RotatableEntityAccessor rotatableEntityAccessor = (RotatableEntityAccessor)player;
            class_2350 gravityDirection = class_2350.method_10162((Random)source.method_9225().field_9229);
            if (rotatableEntityAccessor.gravitychanger$getGravityDirection() == gravityDirection) continue;
            rotatableEntityAccessor.gravitychanger$setGravityDirection(gravityDirection, false);
            GravityCommand.setSendFeedback(source, player, gravityDirection);
            ++i;
        }
        return i;
    }

    public static enum FacingDirection {
        DOWN(-1, "down"),
        UP(-1, "up"),
        FORWARD(0, "forward"),
        BACKWARD(2, "backward"),
        LEFT(3, "left"),
        RIGHT(1, "right");

        private final int horizontalOffset;
        private final String name;

        private FacingDirection(int horizontalOffset, String name) {
            this.horizontalOffset = horizontalOffset;
            this.name = name;
        }

        public int getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public String getName() {
            return this.name;
        }
    }
}

