/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.compat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.ultrusmods.missingwilds.Constants;
import me.ultrusmods.missingwilds.compat.BiomeMakeoverCompat;
import me.ultrusmods.missingwilds.compat.BlockusCompat;
import me.ultrusmods.missingwilds.compat.BygModCompat;
import me.ultrusmods.missingwilds.compat.CharmCompat;
import me.ultrusmods.missingwilds.compat.EcologicsCompat;
import me.ultrusmods.missingwilds.compat.PromenadeCompat;
import me.ultrusmods.missingwilds.compat.TraverseModCompat;
import me.ultrusmods.missingwilds.resource.MissingWildsResources;
import net.fabricmc.loader.api.FabricLoader;

public abstract class ModCompat {
    private final List<LogData> logList = new ArrayList<LogData>();
    public static HashMap<String, ModCompat> modCompats = new HashMap();

    public static void checkModCompat() {
        modCompats.forEach((modId, modCompat) -> {
            if (FabricLoader.getInstance().isModLoaded(modId)) {
                modCompat.addLogs();
                modCompat.logList.forEach(logData -> MissingWildsResources.addLog(logData, modId));
            }
        });
        MissingWildsResources.RESOURCE_PACK.addTag(Constants.id("blocks/fallen_logs"), MissingWildsResources.FALLEN_LOGS);
    }

    public abstract void addLogs();

    public List<LogData> getLogList() {
        return this.logList;
    }

    public void addSimpleLog(String logName) {
        this.getLogList().add(new LogData("fallen_" + logName, this.getMod() + ":" + logName, this.getMod() + ":block/" + logName, this.getMod() + ":block/stripped_" + logName));
    }

    public abstract String getMod();

    static {
        modCompats.put("traverse", new TraverseModCompat());
        modCompats.put("byg", new BygModCompat());
        modCompats.put("blockus", new BlockusCompat());
        modCompats.put("promenade", new PromenadeCompat());
        modCompats.put("charm", new CharmCompat());
        modCompats.put("biomemakeover", new BiomeMakeoverCompat());
        modCompats.put("ecologics", new EcologicsCompat());
    }

    public record LogData(String name, String blockId, String logTexture, String strippedLogTexture) {
    }
}

