/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.module;

import com.yungnickyoung.minecraft.yungsextras.YungsExtrasCommon;
import com.yungnickyoung.minecraft.yungsextras.module.ConfiguredFeatureModule;
import com.yungnickyoung.minecraft.yungsextras.module.FeatureModule;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.ChillzoneDesertFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertGiantTorchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertObeliskFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertSmallRuinsFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampArchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampChurchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampCubbyFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampDoubleArchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampOgreFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampPillarFeature;
import java.util.List;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_6796;
import net.minecraft.class_6814;
import net.minecraft.class_6880;

public class FeatureModuleFabric {
    public static void init() {
        FeatureModuleFabric.registerFeatures();
        ConfiguredFeatureModule.registerConfiguredFeatures();
        ConfiguredFeatureModule.registerPlacedFeatures();
        FeatureModuleFabric.addFeaturesToBiomes();
    }

    private static void registerFeatures() {
        FeatureModule.DESERT_WELL = FeatureModuleFabric.register("desert_well", new DesertWellFeature());
        FeatureModule.DESERT_OBELISK = FeatureModuleFabric.register("desert_obelisk", new DesertObeliskFeature());
        FeatureModule.DESERT_GIANT_TORCH = FeatureModuleFabric.register("desert_giant_torch", new DesertGiantTorchFeature());
        FeatureModule.DESERT_RUINS_0 = FeatureModuleFabric.register("desert_ruins_0", new DesertSmallRuinsFeature());
        FeatureModule.DESERT_CHILLZONE = FeatureModuleFabric.register("desert_chillzone", new ChillzoneDesertFeature());
        FeatureModule.SWAMP_PILLAR = FeatureModuleFabric.register("swamp_pillar", new SwampPillarFeature());
        FeatureModule.SWAMP_OGRE = FeatureModuleFabric.register("swamp_ogre", new SwampOgreFeature());
        FeatureModule.SWAMP_CUBBY = FeatureModuleFabric.register("swamp_cubby", new SwampCubbyFeature());
        FeatureModule.SWAMP_ARCH = FeatureModuleFabric.register("swamp_arch", new SwampArchFeature());
        FeatureModule.SWAMP_DOUBLE_ARCH = FeatureModuleFabric.register("swamp_double_arch", new SwampDoubleArchFeature());
        FeatureModule.SWAMP_CHURCH = FeatureModuleFabric.register("swamp_church", new SwampChurchFeature());
    }

    private static void addFeaturesToBiomes() {
        BiomeModifications.create((class_2960)new class_2960("yungsextras", "vanilla_desert_well_removal")).add(ModificationPhase.REMOVALS, biomeSelectionContext -> biomeSelectionContext.hasBuiltInPlacedFeature((class_6796)class_6814.field_36014.comp_349()), modificationContext -> modificationContext.getGenerationSettings().removeBuiltInFeature((class_6796)class_6814.field_36014.comp_349()));
        BiomeModifications.create((class_2960)new class_2960("yungsextras", "desert_decorations_addition")).add(ModificationPhase.ADDITIONS, context -> FeatureModuleFabric.selectBiomes(context, class_1959.class_1961.field_9368, YungsExtrasCommon.CONFIG.desert.biomeBlacklist, YungsExtrasCommon.CONFIG.desert.additionalBiomeWhitelist), context -> FeatureModuleFabric.modifyBiomes(context, class_1959.class_1961.field_9368));
        BiomeModifications.create((class_2960)new class_2960("yungsextras", "swamp_structures_addition")).add(ModificationPhase.ADDITIONS, context -> FeatureModuleFabric.selectBiomes(context, class_1959.class_1961.field_9364, YungsExtrasCommon.CONFIG.swamp.biomeBlacklist, YungsExtrasCommon.CONFIG.swamp.additionalBiomeWhitelist), context -> FeatureModuleFabric.modifyBiomes(context, class_1959.class_1961.field_9364));
    }

    private static boolean selectBiomes(BiomeSelectionContext context, class_1959.class_1961 biomeCategory, List<String> blacklistedBiomes, List<String> additionalWhitelistedBiomes) {
        String biomeName = context.getBiomeKey().method_29177().toString();
        if (blacklistedBiomes.contains(biomeName)) {
            return false;
        }
        return class_1959.method_40136((class_6880)class_6880.method_40223((Object)context.getBiome())) == biomeCategory || additionalWhitelistedBiomes.contains(biomeName);
    }

    private static void modifyBiomes(BiomeModificationContext context, class_1959.class_1961 biomeCategory) {
        ConfiguredFeatureModule.NAMED_PLACED_FEATURES_BY_BIOME.get(biomeCategory).forEach(namedPlacedFeature -> {
            class_6796 placedFeature = namedPlacedFeature.placedFeature();
            context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13173, placedFeature);
        });
    }

    private static <FC extends class_3037> class_3031<FC> register(String name, class_3031<FC> feature) {
        return (class_3031)class_2378.method_10230((class_2378)class_2378.field_11138, (class_2960)new class_2960("yungsextras", name), feature);
    }
}

