/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Options;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector2dc;
import net.coderbot.iris.vendored.joml.Vector2fc;
import net.coderbot.iris.vendored.joml.Vector2ic;

public class Vector2i
implements Externalizable,
Cloneable,
Vector2ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;

    public Vector2i() {
    }

    public Vector2i(int n) {
        this.x = n;
        this.y = n;
    }

    public Vector2i(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Vector2i(float f, float f2, int n) {
        this.x = Math.roundUsing(f, n);
        this.y = Math.roundUsing(f2, n);
    }

    public Vector2i(double d, double d2, int n) {
        this.x = Math.roundUsing(d, n);
        this.y = Math.roundUsing(d2, n);
    }

    public Vector2i(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
    }

    public Vector2i(Vector2fc vector2fc, int n) {
        this.x = Math.roundUsing(vector2fc.x(), n);
        this.y = Math.roundUsing(vector2fc.y(), n);
    }

    public Vector2i(Vector2dc vector2dc, int n) {
        this.x = Math.roundUsing(vector2dc.x(), n);
        this.y = Math.roundUsing(vector2dc.y(), n);
    }

    public Vector2i(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
    }

    public Vector2i(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector2i(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
    }

    public Vector2i(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
    }

    public Vector2i(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n, intBuffer);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    public Vector2i set(int n) {
        this.x = n;
        this.y = n;
        return this;
    }

    public Vector2i set(int n, int n2) {
        this.x = n;
        this.y = n2;
        return this;
    }

    public Vector2i set(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        return this;
    }

    public Vector2i set(Vector2dc vector2dc) {
        this.x = (int)vector2dc.x();
        this.y = (int)vector2dc.y();
        return this;
    }

    public Vector2i set(Vector2dc vector2dc, int n) {
        this.x = Math.roundUsing(vector2dc.x(), n);
        this.y = Math.roundUsing(vector2dc.y(), n);
        return this;
    }

    public Vector2i set(Vector2fc vector2fc, int n) {
        this.x = Math.roundUsing(vector2fc.x(), n);
        this.y = Math.roundUsing(vector2fc.y(), n);
        return this;
    }

    public Vector2i set(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        return this;
    }

    public Vector2i set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector2i set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Vector2i set(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
        return this;
    }

    public Vector2i set(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n, intBuffer);
        return this;
    }

    @Override
    public int get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector2i setComponent(int n, int n2) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.x = n2;
                break;
            }
            case 1: {
                this.y = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public IntBuffer get(IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, intBuffer.position(), intBuffer);
        return intBuffer;
    }

    @Override
    public IntBuffer get(int n, IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, n, intBuffer);
        return intBuffer;
    }

    public Vector2i sub(Vector2ic vector2ic) {
        this.x -= vector2ic.x();
        this.y -= vector2ic.y();
        return this;
    }

    @Override
    public Vector2i sub(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x - vector2ic.x();
        vector2i.y = this.y - vector2ic.y();
        return vector2i;
    }

    public Vector2i sub(int n, int n2) {
        this.x -= n;
        this.y -= n2;
        return this;
    }

    @Override
    public Vector2i sub(int n, int n2, Vector2i vector2i) {
        vector2i.x = this.x - n;
        vector2i.y = this.y - n2;
        return vector2i;
    }

    @Override
    public long lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public static long lengthSquared(int n, int n2) {
        return n * n + n2 * n2;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static double length(int n, int n2) {
        return Math.sqrt(n * n + n2 * n2);
    }

    @Override
    public double distance(Vector2ic vector2ic) {
        int n = this.x - vector2ic.x();
        int n2 = this.y - vector2ic.y();
        return Math.sqrt(n * n + n2 * n2);
    }

    @Override
    public double distance(int n, int n2) {
        int n3 = this.x - n;
        int n4 = this.y - n2;
        return Math.sqrt(n3 * n3 + n4 * n4);
    }

    @Override
    public long distanceSquared(Vector2ic vector2ic) {
        int n = this.x - vector2ic.x();
        int n2 = this.y - vector2ic.y();
        return n * n + n2 * n2;
    }

    @Override
    public long distanceSquared(int n, int n2) {
        int n3 = this.x - n;
        int n4 = this.y - n2;
        return n3 * n3 + n4 * n4;
    }

    @Override
    public long gridDistance(Vector2ic vector2ic) {
        return Math.abs(vector2ic.x() - this.x()) + Math.abs(vector2ic.y() - this.y());
    }

    @Override
    public long gridDistance(int n, int n2) {
        return Math.abs(n - this.x()) + Math.abs(n2 - this.y());
    }

    public static double distance(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        return Math.sqrt(n5 * n5 + n6 * n6);
    }

    public static long distanceSquared(int n, int n2, int n3, int n4) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        return n5 * n5 + n6 * n6;
    }

    public Vector2i add(Vector2ic vector2ic) {
        this.x += vector2ic.x();
        this.y += vector2ic.y();
        return this;
    }

    @Override
    public Vector2i add(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x + vector2ic.x();
        vector2i.y = this.y + vector2ic.y();
        return vector2i;
    }

    public Vector2i add(int n, int n2) {
        this.x += n;
        this.y += n2;
        return this;
    }

    @Override
    public Vector2i add(int n, int n2, Vector2i vector2i) {
        vector2i.x = this.x + n;
        vector2i.y = this.y + n2;
        return vector2i;
    }

    public Vector2i mul(int n) {
        this.x *= n;
        this.y *= n;
        return this;
    }

    @Override
    public Vector2i mul(int n, Vector2i vector2i) {
        vector2i.x = this.x * n;
        vector2i.y = this.y * n;
        return vector2i;
    }

    public Vector2i mul(Vector2ic vector2ic) {
        this.x *= vector2ic.x();
        this.y *= vector2ic.y();
        return this;
    }

    @Override
    public Vector2i mul(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x * vector2ic.x();
        vector2i.y = this.y * vector2ic.y();
        return vector2i;
    }

    public Vector2i mul(int n, int n2) {
        this.x *= n;
        this.y *= n2;
        return this;
    }

    @Override
    public Vector2i mul(int n, int n2, Vector2i vector2i) {
        vector2i.x = this.x * n;
        vector2i.y = this.y * n2;
        return vector2i;
    }

    public Vector2i div(float f) {
        float f2 = 1.0f / f;
        this.x = (int)((float)this.x * f2);
        this.y = (int)((float)this.y * f2);
        return this;
    }

    @Override
    public Vector2i div(float f, Vector2i vector2i) {
        float f2 = 1.0f / f;
        vector2i.x = (int)((float)this.x * f2);
        vector2i.y = (int)((float)this.y * f2);
        return vector2i;
    }

    public Vector2i div(int n) {
        this.x /= n;
        this.y /= n;
        return this;
    }

    @Override
    public Vector2i div(int n, Vector2i vector2i) {
        vector2i.x = this.x / n;
        vector2i.y = this.y / n;
        return vector2i;
    }

    public Vector2i zero() {
        this.x = 0;
        this.y = 0;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.x);
        objectOutput.writeInt(this.y);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readInt();
        this.y = objectInput.readInt();
    }

    public Vector2i negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    @Override
    public Vector2i negate(Vector2i vector2i) {
        vector2i.x = -this.x;
        vector2i.y = -this.y;
        return vector2i;
    }

    public Vector2i min(Vector2ic vector2ic) {
        this.x = this.x < vector2ic.x() ? this.x : vector2ic.x();
        this.y = this.y < vector2ic.y() ? this.y : vector2ic.y();
        return this;
    }

    @Override
    public Vector2i min(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x < vector2ic.x() ? this.x : vector2ic.x();
        vector2i.y = this.y < vector2ic.y() ? this.y : vector2ic.y();
        return vector2i;
    }

    public Vector2i max(Vector2ic vector2ic) {
        this.x = this.x > vector2ic.x() ? this.x : vector2ic.x();
        this.y = this.y > vector2ic.y() ? this.y : vector2ic.y();
        return this;
    }

    @Override
    public Vector2i max(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x > vector2ic.x() ? this.x : vector2ic.x();
        vector2i.y = this.y > vector2ic.y() ? this.y : vector2ic.y();
        return vector2i;
    }

    @Override
    public int maxComponent() {
        int n;
        int n2 = Math.abs(this.x);
        if (n2 >= (n = Math.abs(this.y))) {
            return 0;
        }
        return 1;
    }

    @Override
    public int minComponent() {
        int n;
        int n2 = Math.abs(this.x);
        if (n2 < (n = Math.abs(this.y))) {
            return 0;
        }
        return 1;
    }

    public Vector2i absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        return this;
    }

    @Override
    public Vector2i absolute(Vector2i vector2i) {
        vector2i.x = Math.abs(this.x);
        vector2i.y = Math.abs(this.y);
        return vector2i;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.x;
        n = 31 * n + this.y;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector2i vector2i = (Vector2i)object;
        if (this.x != vector2i.x) {
            return false;
        }
        return this.y == vector2i.y;
    }

    @Override
    public boolean equals(int n, int n2) {
        if (this.x != n) {
            return false;
        }
        return this.y == n2;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.x) + " " + numberFormat.format(this.y) + ")";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

