/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import com.jozufozu.flywheel.backend.gl.GlStateTracker;
import com.mojang.blaze3d.platform.GlStateManager;

public enum GlBufferType {
    ARRAY_BUFFER(34962),
    ELEMENT_ARRAY_BUFFER(34963),
    PIXEL_PACK_BUFFER(35051),
    PIXEL_UNPACK_BUFFER(35052),
    TRANSFORM_FEEDBACK_BUFFER(35982),
    UNIFORM_BUFFER(35345),
    TEXTURE_BUFFER(35882),
    COPY_READ_BUFFER(36662),
    COPY_WRITE_BUFFER(36663),
    DRAW_INDIRECT_BUFFER(36671),
    ATOMIC_COUNTER_BUFFER(37568),
    DISPATCH_INDIRECT_BUFFER(37102),
    SHADER_STORAGE_BUFFER(37074);

    public final int glEnum;

    private GlBufferType(int glEnum) {
        this.glEnum = glEnum;
    }

    public static GlBufferType fromTarget(int pTarget) {
        return switch (pTarget) {
            case 34962 -> ARRAY_BUFFER;
            case 34963 -> ELEMENT_ARRAY_BUFFER;
            case 35051 -> PIXEL_PACK_BUFFER;
            case 35052 -> PIXEL_UNPACK_BUFFER;
            case 35982 -> TRANSFORM_FEEDBACK_BUFFER;
            case 35345 -> UNIFORM_BUFFER;
            case 35882 -> TEXTURE_BUFFER;
            case 36662 -> COPY_READ_BUFFER;
            case 36663 -> COPY_WRITE_BUFFER;
            case 36671 -> DRAW_INDIRECT_BUFFER;
            case 37568 -> ATOMIC_COUNTER_BUFFER;
            case 37102 -> DISPATCH_INDIRECT_BUFFER;
            case 37074 -> SHADER_STORAGE_BUFFER;
            default -> throw new IllegalArgumentException("Unknown target: " + pTarget);
        };
    }

    public void bind(int buffer) {
        GlStateManager._glBindBuffer((int)this.glEnum, (int)buffer);
    }

    public void unbind() {
        GlStateManager._glBindBuffer((int)this.glEnum, (int)0);
    }

    public int getBoundBuffer() {
        return GlStateTracker.getBuffer(this);
    }
}

