/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.WaitGroup;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTaskEngine
implements TaskEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BatchExecutor");
    private final String name;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final WaitGroup wg = new WaitGroup();
    private final Deque<Runnable> syncTasks = new ConcurrentLinkedDeque<Runnable>();
    private final Deque<Runnable> jobQueue = new ConcurrentLinkedDeque<Runnable>();
    private final List<Thread> threads = new ArrayList<Thread>();
    private final Object jobNotifier = new Object();
    private final int threadCount;

    public ParallelTaskEngine(String name) {
        this.name = name;
        this.threadCount = ParallelTaskEngine.getOptimalThreadCount();
    }

    public WorkGroupBuilder group(String name) {
        return new WorkGroupBuilder(name);
    }

    public void startWorkers() {
        if (this.running.getAndSet(true)) {
            return;
        }
        if (!this.threads.isEmpty()) {
            throw new IllegalStateException("Threads are still alive while in the STOPPED state");
        }
        for (int i = 0; i < this.threadCount; ++i) {
            Thread thread = new Thread((Runnable)new WorkerRunnable(), this.name + " " + i);
            thread.setPriority(Math.max(0, 3));
            thread.start();
            this.threads.add(thread);
        }
        LOGGER.info("Started {} worker threads", (Object)this.threads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorkers() {
        if (!this.running.getAndSet(false)) {
            return;
        }
        if (this.threads.isEmpty()) {
            throw new IllegalStateException("No threads are alive but the executor is in the RUNNING state");
        }
        Iterator<Thread> iterator = this.jobNotifier;
        synchronized (iterator) {
            this.jobNotifier.notifyAll();
        }
        try {
            for (Thread thread : this.threads) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.threads.clear();
        this.jobQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(@NotNull Runnable command) {
        this.jobQueue.add(command);
        this.wg.add(1);
        Object object = this.jobNotifier;
        synchronized (object) {
            this.jobNotifier.notify();
        }
    }

    @Override
    public void syncPoint() {
        Runnable job;
        while ((job = this.jobQueue.pollLast()) != null) {
            this.processTask(job);
        }
        try {
            this.wg.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while ((job = this.syncTasks.pollLast()) != null) {
            job.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Runnable getNextTask() {
        Runnable job = this.jobQueue.pollFirst();
        if (job == null) {
            Object object = this.jobNotifier;
            synchronized (object) {
                try {
                    this.jobNotifier.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return job;
    }

    private void processTask(Runnable job) {
        try {
            job.run();
        }
        catch (Exception e) {
            Flywheel.LOGGER.error("Error running job", (Throwable)e);
        }
        finally {
            this.wg.done();
        }
    }

    private static int getOptimalThreadCount() {
        return class_3532.method_15340((int)Math.max(ParallelTaskEngine.getMaxThreadCount() / 3, ParallelTaskEngine.getMaxThreadCount() - 6), (int)1, (int)10);
    }

    private static int getMaxThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public class WorkGroupBuilder {
        final String name;
        @Nullable
        Runnable finalizer;
        Stream<Runnable> tasks;

        public WorkGroupBuilder(String name) {
            this.name = name;
        }

        public <T> WorkGroupBuilder addTasks(Stream<T> iterable, Consumer<T> consumer) {
            return this.addTasks(iterable.map(it -> () -> consumer.accept(it)));
        }

        public WorkGroupBuilder addTasks(Stream<Runnable> tasks) {
            this.tasks = this.tasks == null ? tasks : Stream.concat(this.tasks, tasks);
            return this;
        }

        public WorkGroupBuilder onComplete(Runnable runnable) {
            this.finalizer = runnable;
            return this;
        }

        public void submit() {
            if (this.tasks == null) {
                return;
            }
            WorkGroup workGroup = new WorkGroup(this.name, this.finalizer);
            this.tasks.map(task -> new WorkGroupTask(workGroup, (Runnable)task)).forEach(ParallelTaskEngine.this::submit);
        }
    }

    private class WorkerRunnable
    implements Runnable {
        private final AtomicBoolean running;

        private WorkerRunnable() {
            this.running = ParallelTaskEngine.this.running;
        }

        @Override
        public void run() {
            while (this.running.get()) {
                Runnable job = ParallelTaskEngine.this.getNextTask();
                if (job == null) continue;
                ParallelTaskEngine.this.processTask(job);
            }
        }
    }

    private class WorkGroup {
        final String name;
        final Runnable finalizer;
        final AtomicInteger running = new AtomicInteger(0);

        public WorkGroup(@Nullable String name, Runnable finalizer) {
            this.name = name;
            this.finalizer = finalizer;
        }

        public void oneDown() {
            if (this.running.decrementAndGet() == 0 && this.finalizer != null) {
                ParallelTaskEngine.this.syncTasks.add(this.finalizer);
            }
        }
    }

    private static class WorkGroupTask
    implements Runnable {
        private final WorkGroup parent;
        private final Runnable wrapped;

        public WorkGroupTask(WorkGroup parent, Runnable wrapped) {
            this.parent = parent;
            this.wrapped = wrapped;
            this.parent.running.incrementAndGet();
        }

        @Override
        public void run() {
            this.wrapped.run();
            this.parent.oneDown();
        }
    }
}

