/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.instancing;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialGroup;
import com.jozufozu.flywheel.api.struct.Instanced;
import com.jozufozu.flywheel.api.struct.StructType;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import com.jozufozu.flywheel.backend.instancing.instancing.GPUInstancer;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancedMaterial;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.backend.model.FallbackAllocator;
import com.jozufozu.flywheel.backend.model.ModelAllocator;
import com.jozufozu.flywheel.backend.model.ModelPool;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.compile.ProgramContext;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.util.Textures;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1159;
import net.minecraft.class_1921;

public class InstancedMaterialGroup<P extends WorldProgram>
implements MaterialGroup {
    protected final InstancingEngine<P> owner;
    protected final class_1921 type;
    private final Map<Instanced<? extends InstanceData>, InstancedMaterial<?>> materials = new HashMap();
    private ModelAllocator allocator;
    private int vertexCount;
    private int instanceCount;

    public InstancedMaterialGroup(InstancingEngine<P> owner, class_1921 type) {
        this.owner = owner;
        this.type = type;
    }

    public <D extends InstanceData> InstancedMaterial<D> material(StructType<D> type) {
        if (type instanceof Instanced) {
            Instanced instanced = (Instanced)type;
            return this.materials.computeIfAbsent(instanced, InstancedMaterial::new);
        }
        throw new ClassCastException("Cannot use type '" + type + "' with GPU instancing.");
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public void render(class_1159 viewProjection, double camX, double camY, double camZ, RenderLayer layer) {
        this.type.method_23516();
        Textures.bindActiveTextures();
        this.renderAll(viewProjection, camX, camY, camZ, layer);
        this.type.method_23518();
    }

    protected void renderAll(class_1159 viewProjection, double camX, double camY, double camZ, RenderLayer layer) {
        this.initializeInstancers();
        this.vertexCount = 0;
        this.instanceCount = 0;
        for (Map.Entry<Instanced<InstanceData>, InstancedMaterial<?>> entry : this.materials.entrySet()) {
            InstancedMaterial<?> material = entry.getValue();
            if (material.nothingToRender()) continue;
            WorldProgram program = (WorldProgram)this.owner.context.getProgram(ProgramContext.create(entry.getKey().getProgramSpec(), Formats.POS_TEX_NORMAL, layer));
            program.bind();
            program.uploadViewProjection(viewProjection);
            program.uploadCameraPos(camX, camY, camZ);
            this.setup(program);
            for (GPUInstancer<?> instancer : material.getAllInstancers()) {
                instancer.render();
                this.vertexCount += instancer.getVertexCount();
                this.instanceCount += instancer.getInstanceCount();
            }
        }
    }

    private void initializeInstancers() {
        ModelAllocator allocator = this.getModelAllocator();
        for (InstancedMaterial<?> material : this.materials.values()) {
            for (GPUInstancer instancer : material.uninitialized) {
                instancer.init(allocator);
            }
            material.uninitialized.clear();
        }
        if (allocator instanceof ModelPool) {
            ModelPool pool = (ModelPool)allocator;
            pool.flush();
        }
    }

    protected void setup(P program) {
    }

    public void clear() {
        this.materials.values().forEach(InstancedMaterial::clear);
    }

    public void delete() {
        this.materials.values().forEach(InstancedMaterial::delete);
        this.materials.clear();
    }

    private ModelAllocator getModelAllocator() {
        if (this.allocator == null) {
            this.allocator = InstancedMaterialGroup.createAllocator();
        }
        return this.allocator;
    }

    private static ModelAllocator createAllocator() {
        if (GlCompat.getInstance().onAMDWindows()) {
            return FallbackAllocator.INSTANCE;
        }
        return new ModelPool(Formats.POS_TEX_NORMAL);
    }
}

