/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.instancing;

import com.jozufozu.flywheel.api.MaterialGroup;
import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.backend.instancing.Engine;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancedMaterialGroup;
import com.jozufozu.flywheel.core.compile.ProgramCompiler;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.fabric.helper.Matrix4fHelper;
import com.jozufozu.flywheel.util.FlwUtil;
import com.jozufozu.flywheel.util.WeakHashSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_4184;

public class InstancingEngine<P extends WorldProgram>
implements Engine {
    public static int MAX_ORIGIN_DISTANCE = 100;
    protected class_2338 originCoordinate = class_2338.field_10980;
    protected final ProgramCompiler<P> context;
    protected final GroupFactory<P> groupFactory;
    protected final boolean ignoreOriginCoordinate;
    protected final Map<RenderLayer, Map<class_1921, InstancedMaterialGroup<P>>> layers;
    private final WeakHashSet<OriginShiftListener> listeners;

    public static <P extends WorldProgram> Builder<P> builder(ProgramCompiler<P> context) {
        return new Builder<P>(context);
    }

    public InstancingEngine(ProgramCompiler<P> context, GroupFactory<P> groupFactory, boolean ignoreOriginCoordinate) {
        this.context = context;
        this.ignoreOriginCoordinate = ignoreOriginCoordinate;
        this.listeners = new WeakHashSet();
        this.groupFactory = groupFactory;
        this.layers = new EnumMap<RenderLayer, Map<class_1921, InstancedMaterialGroup<P>>>(RenderLayer.class);
        for (RenderLayer value : RenderLayer.values()) {
            this.layers.put(value, new HashMap());
        }
    }

    @Override
    public MaterialGroup state(RenderLayer layer, class_1921 type) {
        return this.layers.get((Object)layer).computeIfAbsent(type, t -> this.groupFactory.create(this, (class_1921)t));
    }

    @Override
    public void render(TaskEngine taskEngine, RenderLayerEvent event) {
        class_1159 viewProjection;
        double camZ;
        double camY;
        double camX;
        if (!this.ignoreOriginCoordinate) {
            camX = event.camX - (double)this.originCoordinate.method_10263();
            camY = event.camY - (double)this.originCoordinate.method_10264();
            camZ = event.camZ - (double)this.originCoordinate.method_10260();
            viewProjection = class_1159.method_24021((float)((float)(-camX)), (float)((float)(-camY)), (float)((float)(-camZ)));
            Matrix4fHelper.multiplyBackward(viewProjection, event.viewProjection);
        } else {
            camX = event.camX;
            camY = event.camY;
            camZ = event.camZ;
            viewProjection = event.viewProjection;
        }
        this.getGroupsToRender(event.getLayer()).forEach(group -> group.render(viewProjection, camX, camY, camZ, event.getLayer()));
    }

    private Stream<InstancedMaterialGroup<P>> getGroupsToRender(@Nullable RenderLayer layer) {
        if (layer != null) {
            return this.layers.get((Object)layer).values().stream();
        }
        return this.layers.values().stream().flatMap(FlwUtil::mapValues);
    }

    @Override
    public void delete() {
        for (Map<class_1921, InstancedMaterialGroup<P>> groups : this.layers.values()) {
            groups.values().forEach(InstancedMaterialGroup::delete);
        }
    }

    @Override
    public class_2382 getOriginCoordinate() {
        return this.originCoordinate;
    }

    public void addListener(OriginShiftListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void beginFrame(class_4184 info) {
        int cX = class_3532.method_15357((double)info.method_19326().field_1352);
        int cY = class_3532.method_15357((double)info.method_19326().field_1351);
        int cZ = class_3532.method_15357((double)info.method_19326().field_1350);
        int dX = cX - this.originCoordinate.method_10263();
        int dY = cY - this.originCoordinate.method_10264();
        int dZ = cZ - this.originCoordinate.method_10260();
        if (Math.abs(dX) > MAX_ORIGIN_DISTANCE || Math.abs(dY) > MAX_ORIGIN_DISTANCE || Math.abs(dZ) > MAX_ORIGIN_DISTANCE) {
            this.originCoordinate = new class_2338(cX, cY, cZ);
            for (Map<class_1921, InstancedMaterialGroup<P>> groups : this.layers.values()) {
                groups.values().forEach(InstancedMaterialGroup::clear);
            }
            this.listeners.forEach(OriginShiftListener::onOriginShift);
        }
    }

    @Override
    public void addDebugInfo(List<String> info) {
        info.add("GL33 Instanced Arrays");
        info.add("Instances: " + this.getGroupsToRender(null).mapToInt(InstancedMaterialGroup::getInstanceCount).sum());
        info.add("Vertices: " + this.getGroupsToRender(null).mapToInt(InstancedMaterialGroup::getVertexCount).sum());
        info.add("Origin: " + this.originCoordinate.method_10263() + ", " + this.originCoordinate.method_10264() + ", " + this.originCoordinate.method_10260());
    }

    public static class Builder<P extends WorldProgram> {
        protected final ProgramCompiler<P> context;
        protected GroupFactory<P> groupFactory = InstancedMaterialGroup::new;
        protected boolean ignoreOriginCoordinate;

        public Builder(ProgramCompiler<P> context) {
            this.context = context;
        }

        public Builder<P> setGroupFactory(GroupFactory<P> groupFactory) {
            this.groupFactory = groupFactory;
            return this;
        }

        public Builder<P> setIgnoreOriginCoordinate(boolean ignoreOriginCoordinate) {
            this.ignoreOriginCoordinate = ignoreOriginCoordinate;
            return this;
        }

        public InstancingEngine<P> build() {
            return new InstancingEngine<P>(this.context, this.groupFactory, this.ignoreOriginCoordinate);
        }
    }

    @FunctionalInterface
    public static interface GroupFactory<P extends WorldProgram> {
        public InstancedMaterialGroup<P> create(InstancingEngine<P> var1, class_1921 var2);
    }

    @FunctionalInterface
    public static interface OriginShiftListener {
        public void onOriginShift();
    }
}

