/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.materials;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.util.Color;
import net.minecraft.class_765;

public abstract class BasicData
extends InstanceData
implements FlatLit<BasicData> {
    public byte blockLight;
    public byte skyLight;
    public byte r = (byte)-1;
    public byte g = (byte)-1;
    public byte b = (byte)-1;
    public byte a = (byte)-1;

    @Override
    public BasicData setBlockLight(int blockLight) {
        this.blockLight = (byte)blockLight;
        this.markDirty();
        return this;
    }

    @Override
    public BasicData setSkyLight(int skyLight) {
        this.skyLight = (byte)skyLight;
        this.markDirty();
        return this;
    }

    @Override
    public int getPackedLight() {
        return class_765.method_23687((int)this.blockLight, (int)this.skyLight);
    }

    public BasicData setColor(Color color) {
        this.r = (byte)color.getRed();
        this.g = (byte)color.getGreen();
        this.b = (byte)color.getBlue();
        this.a = (byte)color.getAlpha();
        this.markDirty();
        return this;
    }

    public BasicData setColor(int color) {
        return this.setColor(color, false);
    }

    public BasicData setColor(int color, boolean alpha) {
        byte r = (byte)(color >> 16 & 0xFF);
        byte g = (byte)(color >> 8 & 0xFF);
        byte b = (byte)(color & 0xFF);
        if (alpha) {
            byte a = (byte)(color >> 24 & 0xFF);
            return this.setColor(r, g, b, a);
        }
        return this.setColor(r, g, b);
    }

    public BasicData setColor(int r, int g, int b) {
        return this.setColor((byte)r, (byte)g, (byte)b);
    }

    public BasicData setColor(byte r, byte g, byte b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.markDirty();
        return this;
    }

    public BasicData setColor(byte r, byte g, byte b, byte a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.markDirty();
        return this;
    }
}

