/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.core.layout.BufferLayout;
import com.jozufozu.flywheel.core.layout.CommonItems;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferBuilder;
import com.jozufozu.flywheel.core.vertex.BlockVertexListUnsafe;
import com.jozufozu.flywheel.core.vertex.BlockWriterUnsafe;
import com.jozufozu.flywheel.fabric.helper.BufferBuilderHelper;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import net.minecraft.class_287;
import net.minecraft.class_290;

public class BlockVertex
implements VertexType {
    public static final BufferLayout FORMAT = BufferLayout.builder().addItems(CommonItems.VEC3, CommonItems.RGBA, CommonItems.UV, CommonItems.LIGHT_SHORT, CommonItems.NORMAL, CommonItems.PADDING_BYTE).build();

    @Override
    public BufferLayout getLayout() {
        return FORMAT;
    }

    @Override
    public BlockWriterUnsafe createWriter(ByteBuffer buffer) {
        return new BlockWriterUnsafe(this, buffer);
    }

    @Override
    public BlockVertexListUnsafe createReader(ByteBuffer buffer, int vertexCount) {
        return new BlockVertexListUnsafe(buffer, vertexCount);
    }

    @Override
    public String getShaderHeader() {
        return "layout (location = 0) in vec3 _flw_v_pos;\nlayout (location = 1) in vec4 _flw_v_color;\nlayout (location = 2) in vec2 _flw_v_texCoords;\nlayout (location = 3) in vec2 _flw_v_light;\nlayout (location = 4) in vec3 _flw_v_normal;\n\nVertex FLWCreateVertex() {\n\tVertex v;\n\tv.pos = _flw_v_pos;\n\tv.color = _flw_v_color;\n\tv.texCoords = _flw_v_texCoords;\n\tv.light = _flw_v_light;\n\tv.normal = _flw_v_normal;\n\treturn v;\n}\n";
    }

    public BlockVertexListUnsafe.Shaded createReader(ByteBuffer buffer, int vertexCount, int unshadedStartVertex) {
        return new BlockVertexListUnsafe.Shaded(buffer, vertexCount, unshadedStartVertex);
    }

    public VertexList createReader(class_287 bufferBuilder) {
        Pair pair = bufferBuilder.method_22632();
        class_287.class_4574 drawState = (class_287.class_4574)pair.getFirst();
        if (drawState.method_22634() != class_290.field_1590) {
            throw new RuntimeException("Cannot use BufferBuilder with " + drawState.method_22634());
        }
        ByteBuffer buffer = (ByteBuffer)pair.getSecond();
        BufferBuilderHelper.fixByteOrder(bufferBuilder, buffer);
        if (bufferBuilder instanceof ShadeSeparatedBufferBuilder) {
            ShadeSeparatedBufferBuilder separated = (ShadeSeparatedBufferBuilder)bufferBuilder;
            return this.createReader(buffer, drawState.method_22635(), separated.getUnshadedStartVertex());
        }
        return this.createReader(buffer, drawState.method_22635());
    }
}

