/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.event;

import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.fabric.event.EventContext;
import com.jozufozu.flywheel.fabric.helper.Matrix4fHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_638;

public class RenderLayerEvent
extends EventContext {
    private final class_638 world;
    public final class_1921 type;
    public final class_4587 stack;
    public final class_1159 viewProjection;
    public final class_4599 buffers;
    public final double camX;
    public final double camY;
    public final double camZ;
    public final RenderLayer layer;

    public RenderLayerEvent(class_638 world, class_1921 type, class_4587 stack, class_4599 buffers, double camX, double camY, double camZ) {
        this.world = world;
        this.type = type;
        this.stack = stack;
        this.viewProjection = stack.method_23760().method_23761().method_22673();
        Matrix4fHelper.multiplyBackward(this.viewProjection, RenderSystem.getProjectionMatrix());
        this.buffers = buffers;
        this.camX = camX;
        this.camY = camY;
        this.camZ = camZ;
        this.layer = RenderLayer.getPrimaryLayer(type);
    }

    @Nullable
    public RenderLayer getLayer() {
        return this.layer;
    }

    public class_638 getWorld() {
        return this.world;
    }

    public class_1921 getType() {
        return this.type;
    }

    public class_1159 getViewProjection() {
        return this.viewProjection;
    }

    public double getCamX() {
        return this.camX;
    }

    public double getCamY() {
        return this.camY;
    }

    public double getCamZ() {
        return this.camZ;
    }

    public String toString() {
        return "RenderLayerEvent[" + this.layer + "][world=" + this.world + ", type=" + this.type + ", stack=" + this.stack + ", viewProjection=" + this.viewProjection + ", buffers=" + this.buffers + ", camX=" + this.camX + ", camY=" + this.camY + ", camZ=" + this.camZ + "]";
    }
}

