/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.fabric.model;

import com.jozufozu.flywheel.Flywheel;
import io.vram.frex.api.material.RenderMaterial;
import io.vram.frex.fabric.compat.FabricQuadView;
import java.lang.reflect.Field;
import link.infra.indium.renderer.RenderMaterialImpl;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.QuadViewImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_4696;

public class FabricModelUtil {
    public static final boolean INDIUM_LOADED = FabricLoader.getInstance().isModLoaded("indium");
    public static final boolean FREX_LOADED = FabricLoader.getInstance().isModLoaded("frex");
    private static final BlendModeGetter BLEND_MODE_GETTER = FabricModelUtil.createBlendModeGetter();
    private static final ShadedPredicate SHADED_PREDICATE = FabricModelUtil.createShadedPredicate();

    private static BlendModeGetter createBlendModeGetter() {
        if (FabricLoader.getInstance().isModLoaded("frex")) {
            try {
                Field frexQuadField = FabricQuadView.class.getDeclaredField("wrapped");
                frexQuadField.setAccessible(true);
                return quad -> {
                    try {
                        RenderMaterial frexMaterial = ((io.vram.frex.api.mesh.QuadView)frexQuadField.get(quad)).material();
                        return switch (frexMaterial.preset()) {
                            case 1 -> BlendMode.DEFAULT;
                            case 2 -> BlendMode.SOLID;
                            case 3 -> BlendMode.CUTOUT_MIPPED;
                            case 4 -> BlendMode.CUTOUT;
                            case 5 -> BlendMode.TRANSLUCENT;
                            case 0 -> {
                                if (frexMaterial.transparency() != 0) {
                                    yield BlendMode.TRANSLUCENT;
                                }
                                if (frexMaterial.cutout() == 0) {
                                    yield BlendMode.SOLID;
                                }
                                if (frexMaterial.unmipped()) {
                                    yield BlendMode.CUTOUT;
                                }
                                yield BlendMode.CUTOUT_MIPPED;
                            }
                            default -> BlendMode.DEFAULT;
                        };
                    }
                    catch (Exception exception) {
                        return BlendMode.DEFAULT;
                    }
                };
            }
            catch (Exception e) {
                Flywheel.LOGGER.error("Detected FREX but failed to load quad wrapper field", (Throwable)e);
            }
        } else {
            if (FabricLoader.getInstance().isModLoaded("indium")) {
                return quad -> ((RenderMaterialImpl)quad.material()).blendMode(0);
            }
            if (RendererAccess.INSTANCE.getRenderer() instanceof IndigoRenderer) {
                return quad -> ((net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl)quad.material()).blendMode(0);
            }
        }
        return quad -> BlendMode.DEFAULT;
    }

    private static ShadedPredicate createShadedPredicate() {
        if (FREX_LOADED) {
            try {
                Field frexQuadViewField = FabricQuadView.class.getDeclaredField("wrapped");
                frexQuadViewField.setAccessible(true);
                return quad -> {
                    try {
                        io.vram.frex.api.mesh.QuadView frexQuadView = (io.vram.frex.api.mesh.QuadView)frexQuadViewField.get(quad);
                        return !frexQuadView.material().disableDiffuse();
                    }
                    catch (Exception exception) {
                        return true;
                    }
                };
            }
            catch (Exception e) {
                Flywheel.LOGGER.error("Detected FREX but failed to load quad view wrapper field.", (Throwable)e);
            }
        } else {
            if (INDIUM_LOADED) {
                return quad -> ((link.infra.indium.renderer.mesh.QuadViewImpl)quad).hasShade();
            }
            if (RendererAccess.INSTANCE.getRenderer() instanceof IndigoRenderer) {
                return quad -> ((QuadViewImpl)quad).hasShade();
            }
        }
        return quad -> true;
    }

    public static BlendMode getBlendMode(QuadView quad) {
        return BLEND_MODE_GETTER.getBlendMode(quad);
    }

    public static boolean isShaded(QuadView quad) {
        return SHADED_PREDICATE.isShaded(quad);
    }

    public static boolean doesLayerMatch(class_2680 modelState, class_1921 layer) {
        return class_4696.method_23679((class_2680)modelState) == layer;
    }

    private static interface BlendModeGetter {
        public BlendMode getBlendMode(QuadView var1);
    }

    private static interface ShadedPredicate {
        public boolean isShaded(QuadView var1);
    }
}

