/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

public class RenderMath {
    public static byte nb(float f) {
        return (byte)(f * 127.0f);
    }

    public static float f(byte b) {
        return (float)b / 127.0f;
    }

    public static float uf(byte b) {
        return (float)Byte.toUnsignedInt(b) / 255.0f;
    }

    public static byte unb(float f) {
        return (byte)Math.floor(f * 255.0f);
    }

    public static int nextPowerOf2(int a) {
        int h = Integer.highestOneBit(a);
        return h == a ? h : h << 1;
    }

    public static boolean isPowerOf2(int n) {
        int b = n & n - 1;
        return b == 0 && n != 0;
    }

    public static double lengthSqr(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt(RenderMath.lengthSqr(x, y, z));
    }

    public static float rad(double angle) {
        if (angle == 0.0) {
            return 0.0f;
        }
        return (float)(angle / 180.0 * Math.PI);
    }

    public static float deg(double angle) {
        if (angle == 0.0) {
            return 0.0f;
        }
        return (float)(angle * 180.0 / Math.PI);
    }

    public static float angleLerp(double pct, double current, double target) {
        return (float)(current + (double)RenderMath.getShortestAngleDiff(current, target) * pct);
    }

    public static float getShortestAngleDiff(double current, double target) {
        return (float)((((target %= 360.0) - (current %= 360.0)) % 360.0 + 540.0) % 360.0 - 180.0);
    }

    public static float diffuseLight(float x, float y, float z, boolean shaded) {
        if (!shaded) {
            return 1.0f;
        }
        return Math.min(x * x * 0.6f + y * y * ((3.0f + y) / 4.0f) + z * z * 0.8f, 1.0f);
    }

    public static float diffuseLightNether(float x, float y, float z, boolean shaded) {
        if (!shaded) {
            return 0.9f;
        }
        return Math.min(x * x * 0.6f + y * y * 0.9f + z * z * 0.8f, 1.0f);
    }
}

